@extends('admin.layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between mb20">
            <h1 class="title-bar">{{__("Vendor Requests")}}</h1>
        </div>
        @include('admin.message')
        <div class="filter-div d-flex justify-content-between ">
            <div class="col-left">
                @if(!empty($rows))
                    <form method="post" action="{{route('user.admin.userUpgradeRequestApproved')}}" class="filter-form filter-form-left d-flex justify-content-start">
                        {{csrf_field()}}
                        <select name="action" class="form-control">
                            <option value="">{{__(" Bulk Actions ")}}</option>
                            <option value="approved">{{__(" Approved ")}}</option>
                            <option value="delete">{{__(" Delete ")}}</option>
                        </select>
                        <button data-confirm="{{__("Do you want to delete?")}}" class="btn-info btn btn-icon dungdt-apply-form-btn" type="button">{{__('Apply')}}</button>
                    </form>
                @endif
            </div>

        </div>
        <div class="text-right">
            <p><i>{{__('Found :total items',['total'=>$rows->total()])}}</i></p>
        </div>
        <div class="panel">
            <div class="panel-body">
                <form action="" class="bravo-form-item">
                    <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                        <tr>
                            <th width="60px"><input type="checkbox" class="check-all"></th>
                            <th>{{__('Name')}}</th>
                            <th>{{__('Email')}}</th>
                            <th>{{ __('Role request')}}</th>
                            <th class="date">{{ __('Date request')}}</th>
                            <th class="date">{{ __('Reject / Approved Date')}}</th>
                            <th>{{ __('Approved / Reject By')}}</th>
                            <th class="status">{{__('Status')}}</th>
                            <th>{{__('Actions')}}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if($rows->total() > 0)
                            @foreach($rows as $row)
                                <tr>
                                    <td><input type="checkbox" name="ids[]" value="{{$row->id}}" class="check-item"></td>
                                    <td class="title">
                                        <a href="{{route('user.admin.detail',['id'=>@$row->user->id])}}">{{@$row->user->getDisplayName()}}</a>
                                    </td>
                                    <td>{{$row->user->email}}</td>
                                    <td>
                                        @php $role = $row->role;
                                    if(!empty($role)){
                                        echo e(ucfirst($role->name));
                                    }
                                        @endphp
                                    </td>
                                    <td>{{ display_date($row->created_at)}}</td>
                                    <td>{{ $row->approved_time ? display_date($row->approved_time) : ''}}</td>
                                    <td>{{ $row->approvedBy->getDisplayName()}}</td>
                                    <td class="status"><span class="badge badge-{{ $row->status }}">{{ $row->status }}</span></td>
                                    <td class="action-button">
                                            <a class="btn btn-sm btn-primary" title="Edit" target="_blank" href="{{route('user.admin.detail',$row->user_id)}}">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                        @if($row->status!='approved' && $row->status!='reject')
                                            <a class="btn btn-sm btn-success approve-user" data-id="{{$row->id}}" title="Approve"  href="{{route('user.admin.upgradeId',['id' => $row->id])}}">
                                                <i class="fa fa-check"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger reject-user" data-id="{{$row->id}}" title="Reject" data-toggle="modal" data-target="#exampleModalCenter"><i class="fa fa-close"></i></button>
                                        @endif
                                        @if($row->status!='approved' && $row->status=='reject')
                                            <button type="button" class="btn btn-info view-reject-reason" title="View" data-id="{{$row->id}}"><i class="fa fa-eye"></i></button>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="8">{{__("No data")}}</td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                    </div>
                </form>
                {{$rows->appends(request()->query())->links()}}
                <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLongTitle">{{__("Cancel Reason")}}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form action="">
                                <div class="form-group">
                                    <input type="hidden" id="reason_id" name="reason_id">
                                    <textarea name="cancel_reason" id="cancel_reason" rows="5" style="width: 100%;"></textarea>
                                    <span id="valid_sms" style="color:red; margin-top:10px;display:none">{{__('this field is required')}}</span>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary" id="submit-reason">Save changes</button>
                        </div>
                        </div>
                    </div>
                </div>
                <div class="modal fade" id="viewRejectReason" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLongTitle">{{__("Cancel Reason")}}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">  
                            <p id="showCancelContent"></p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        $(document).ready(function () {
            // $('.approve-user').click(function (e) {
            //     e.preventDefault();
            //     if(confirm('Are you sure approve?')){
            //         ids = '<input type="hidden" name="ids[]" value="'+$(this).data('id')+'">';
            //         form = $('.dungdt-apply-form-btn').closest('form');
            //         form.append(ids);
            //         form.find('select').val('approved');
            //         form.submit();
            //     }
            // });
            // cancel reason 
            $('.reject-user').click(function(e){
                var id = $(this).data('id');
                $('#reason_id').val(id);

                $("#submit-reason").on("click",function(){
                    var cancelReason = $("#cancel_reason").val();
                    
                    if(cancelReason === ""){
                        console.log("massage null");
                        $("#valid_sms")[0].style.display = "block";
                        $("#cancel_reason")[0].style.borderColor = "red";
                    }else{
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                            }
                        });
                        var url = '{{ route("vendor.reject", ":id") }}';
                            url = url.replace(':id', id );
                        $.ajax({
                            url: url,
                            method: 'post',
                            data: {
                                cancel_reason: $('#cancel_reason').val(),
                            },
                            success: function(result){
                                // console.log(result);
                                $('#exampleModalCenter').modal('hide');
                                location.reload();
                            }
                        });
                        
                    }
                })
            });
            // cancel reason view
            $('.view-reject-reason').on("click",function(){
                var id = $(this).data('id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                    }
                });
                var url = '{{ route("vendor.reject.view", ":id") }}';
                    url = url.replace(':id', id );
                $.ajax({
                    url: url,
                    method: 'get',
                    success: function(result){
                        var cancelReason = result.cancel_reason;
                        $("#showCancelContent").html(cancelReason);
                        $('#viewRejectReason').modal('show');
                        
                    }
                });
            })
            

        })
    </script>
@endpush
