@extends('layouts.user')
@section('content')

<h2 class="title-bar no-border-bottom">
    {{__("Domain Registration")}}
</h2>
@include('admin.message')
<div class="vendor-domain-manager">
    @if($get_vendor_domain)
    @if($get_vendor_domain->id_active != 1)
    <div class="vendor-domain send-request">
        <h4>{{__("You have already sent a request")}}</h4>
        <h4>{{__("please wait for admin approval")}}</h4>
    </div>
    @else
    <div class="vendor-domain approved-request">
        <h4>{{__("Your domain is approved")}}</h4>
    </div>
    @endif
    @else
    <div class="vendor-domain-registration-from">
        <form action="{{route('vendor.domain.store')}}" method="post">
            @csrf
            <div class="form-group">
                <label class="control-label">URL Type</label>
                <div class="">
                    <select name="url_type" class="form-control @error('url') is-invalid @enderror">
                        <option value="">-- Please Select --</option>
                        <option value="Sub Folder"> Sub Folder</option>
                        <option value="Sub Domain"> Sub Domain</option>
                        <option value="Domain"> Domain</option>
                    </select>
                    @error('url')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="from-group">
                <label class="control-label">Name of Subdomain/Subfolder/Domain </label>
                <div class="">
                    <input type="text" class="form-control @error('domain_name') is-invalid @enderror"
                        name="domain_name">
                    @error('domain_name')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="d-flex justify-content-between">
                <button class="btn btn-primary" type="submit"><i class="fa fa-save"></i> Sand</button>
            </div>
        </form>
    </div>
    @endif

</div>

@endsection