@extends('layouts.user')
@section('content')

<h2 class="title-bar no-border-bottom">
    {{__("Vendor Settings")}}
</h2>
@include('admin.message')
<div class="vendor-domain-manager">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <form action="{{route('vendor.access.module.store')}}" method="post">
                    @csrf
                    <div class="card">
                        <div class="card-header">
                            <h5>Access Modules</h5>
                        </div>
                        <div class="card-body">
                            @foreach($active_modules as $module)
                            @php
                            $explode_value = explode("_",$module);
                            $vendor_modules_json_decode = json_decode($vendor_modules->module_accesses);
                            @endphp
                            @if($module != "dashboard_vendor_access")
                            <div class="module-item">
                                <input type="checkbox" name="module_access[]" value="{{$module}}" id="{{$module}}" <?php if(in_array($module,$vendor_modules_json_decode)) echo 'checked="checked"';?>>
                                <label for="{{$module}}">{{ucfirst($explode_value[0])}}</label>
                            </div>
                            @endif
                            @endforeach
                        </div>
                        <div class="card-footer">
                            <button class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-6">
                <form action="{{route('vendor.payment.method.store')}}" method="post">
                    @csrf
                    <div class="card">
                        <div class="card-header">
                            <h5>Payment Method</h5>
                        </div>
                        <div class="card-body">
                            @php
                            $vendor_payment_method_json_decode = json_decode($vendor_modules->payment_method);
                            @endphp
                            @foreach($gateways as $key => $gateway)
                                @if($gateway->name != "Offline Payment")
                                    <div class="payment-item">
                                        <input type="checkbox" name="payment_method[]" value="{{$gateway->name}}" id="{{$key}}" <?php if(in_array($gateway->name,$vendor_payment_method_json_decode)) echo 'checked="checked"';?>>
                                        <label for="{{$key}}">{{$gateway->name}}</label>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        <div class="card-footer">
                            <button class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection