## <small>2.3.4 (2019-02-07)</small>

* #469 - fixes example in README, tested with a fresh vue-cli project ([b0037c9](https://github.com/vue-generators/vue-form-generator/commit/b0037c9))
* #551 - added "is-disabled" class to the radios label ([1e9db8e](https://github.com/vue-generators/vue-form-generator/commit/1e9db8e)), closes [#551](https://github.com/vue-generators/vue-form-generator/issues/551)
* Add vfg-field-matrix into the readme ([a898201](https://github.com/vue-generators/vue-form-generator/commit/a898201))
* added optional field property `debounceValidateTime` which works at the field level, allowing indivi ([d98fa50](https://github.com/vue-generators/vue-form-generator/commit/d98fa50))
* Ref #563 - return unique validation errors (prevents multiple validators from returning "this field  ([f9c699b](https://github.com/vue-generators/vue-form-generator/commit/f9c699b)), closes [#563](https://github.com/vue-generators/vue-form-generator/issues/563)
* single-quotes fix ([5756317](https://github.com/vue-generators/vue-form-generator/commit/5756317))
* Update validators.js ([a282933](https://github.com/vue-generators/vue-form-generator/commit/a282933))
* updated abstractField test, seems the `field.formOptions` wasn't being updated, the `this.$parent.op ([8c1f462](https://github.com/vue-generators/vue-form-generator/commit/8c1f462))
* updated package-lock with latest deps ([f7d7c71](https://github.com/vue-generators/vue-form-generator/commit/f7d7c71))



## <small>2.3.3 (2018-12-14)</small>

* #535, #526 - reversed "deep property path" fix ([da32bde](https://github.com/vue-generators/vue-form-generator/commit/da32bde)), closes [#535](https://github.com/vue-generators/vue-form-generator/issues/535) [#526](https://github.com/vue-generators/vue-form-generator/issues/526)
* added "item.disabled" logic, supporting both boolean values and a function that is passed a referenc ([b227eb4](https://github.com/vue-generators/vue-form-generator/commit/b227eb4))
* added "options" to VFG install function, appending custom "validators" to the validators object that ([892469e](https://github.com/vue-generators/vue-form-generator/commit/892469e))
* added "type" attribute to inside buttons schema, defaults to "button" when one is not provided ([3306893](https://github.com/vue-generators/vue-form-generator/commit/3306893))
* added an optional "unique" flag to "getFieldID" that appends lodash "uniqueId" to the ID when true.  ([ab1daeb](https://github.com/vue-generators/vue-form-generator/commit/ab1daeb)), closes [#468](https://github.com/vue-generators/vue-form-generator/issues/468)
* added newline ([5813f0a](https://github.com/vue-generators/vue-form-generator/commit/5813f0a))
* Codacy (guard-for-in) fix ([4e81d2d](https://github.com/vue-generators/vue-form-generator/commit/4e81d2d))
* code fix ([b3a1010](https://github.com/vue-generators/vue-form-generator/commit/b3a1010))
* Fix required number input does not require a value ([f95b38c](https://github.com/vue-generators/vue-form-generator/commit/f95b38c))
* fixed code structure ([3b750b3](https://github.com/vue-generators/vue-form-generator/commit/3b750b3))
* fixed single-quotes ([dfee175](https://github.com/vue-generators/vue-form-generator/commit/dfee175))
* fixes #480 - dates are always passed to "date" and "datetime-local" elements using the standard form ([db3413f](https://github.com/vue-generators/vue-form-generator/commit/db3413f)), closes [#480](https://github.com/vue-generators/vue-form-generator/issues/480)
* fixes an issue with fieldPikaday modifying the field schema and attaching `this.$el` to it, the pika ([2024204](https://github.com/vue-generators/vue-form-generator/commit/2024204))
* listen for model-updated from `fields`, and fix `debounceFormatFunction` property to match fieldInpu ([7ad1fca](https://github.com/vue-generators/vue-form-generator/commit/7ad1fca))
* migrated VFG docs to newer GitBooks, created GitHub Repo for Docs to allow for easier maintenance, u ([d372f5b](https://github.com/vue-generators/vue-form-generator/commit/d372f5b))
* feat: add maxElements slot to fieldVueMultiSelect ([2e91a2f](https://github.com/vue-generators/vue-form-generator/commit/2e91a2f))



## <small>2.3.2 (2018-10-22)</small>

* Export dist ([9912b5e](https://github.com/vue-generators/vue-form-generator/commit/9912b5e))
* Fix deep property path not working ([fb02f26](https://github.com/vue-generators/vue-form-generator/commit/fb02f26))
* Fix fieldSubmit not calling validate method ([c82c44b](https://github.com/vue-generators/vue-form-generator/commit/c82c44b))
* Fix Rawgit shut down ([34e08a6](https://github.com/vue-generators/vue-form-generator/commit/34e08a6))
* docs: replace duplicated 2.3.0 with 2.3.1 ([69bbfce](https://github.com/vue-generators/vue-form-generator/commit/69bbfce))
* feat(fields): add required attribute to checkbox component ([2b3c7e5](https://github.com/vue-generators/vue-form-generator/commit/2b3c7e5))
* feat(fields): add required attribute to radios component ([8d04252](https://github.com/vue-generators/vue-form-generator/commit/8d04252))



<a name="2.3.1"></a>
## 2.3.1 (2018-10-03)

* Use lodash-webpack-plugin for even better size
* Added required attribute to textarea


<a name="2.3.0"></a>
## 2.3.0 (2018-09-19)

* Fixed issue with SCSS variables being referenced incorrectly (#449)
* Updated README to include new third-party VFG Fields
* Rework of formGenerator use a component
* Allow HTML for Field Label and Hints
* Updated package.json URL's for VFG
* Added a "noResult" slot to FieldVueMultiSelect
* Include a reference to the VFG instance that triggered a "validated" event (3rd param)
* Fixed a number parsing bug in IE/Edge with FieldInput
* Added support for Bootstrap CSS Classes (`form-group` will not set width on `col-*` elements)



<a name="2.2.2"></a>
## 2.2.2 (2018-04-24)

* Fix NaN with value 0 on input type number/range.
* Fix bug in fieldUpload that threw error due to $event not being defined
* Added $event to onValidationError in fieldSubmit
* Fixed bug with validationErrorClass and validationSuccessClass depending on each
* Made DEBOUNCE_FORMAT_MS configurable in fieldInput, just pass `debounceFormatTimeout: TIME_IN_MS` in field schema
* $event.preventDefault() called when using async validation with fieldSubmit to prevent unwanted form submissions



<a name="2.2.1"></a>
## 2.2.1 (2018-03-09)

* ... ([eadccc2](https://github.com/icebob/vue-form-generator/commit/eadccc2))
* #409 - fixed id property in fieldUpdate ([b86fddf](https://github.com/icebob/vue-form-generator/commit/b86fddf))
* fixed markdown link ([3ef928a](https://github.com/icebob/vue-form-generator/commit/3ef928a))
* removed extra paren ([a6df78b](https://github.com/icebob/vue-form-generator/commit/a6df78b))
* resolves #368 added vue-tel-input ([a8859b3](https://github.com/icebob/vue-form-generator/commit/a8859b3)), closes [#368](https://github.com/icebob/vue-form-generator/issues/368)
* setup automate releasing ([6e6527f](https://github.com/icebob/vue-form-generator/commit/6e6527f))



<a name="2.2.0"></a>
# 2.2.0 (2018-01-21)

* add console.log ([fa779bd](https://github.com/icebob/vue-form-generator/commit/fa779bd))
* add console.log to debug ([d05818e](https://github.com/icebob/vue-form-generator/commit/d05818e))
* add indent ([026439a](https://github.com/icebob/vue-form-generator/commit/026439a))
* add unscape html for error message. ([20b8d9d](https://github.com/icebob/vue-form-generator/commit/20b8d9d))
* added "getLabelClasses" and unit test, using the fieldClasses unit test as an example ([8c01307](https://github.com/icebob/vue-form-generator/commit/8c01307))
* added labelClasses support ([acdbb6c](https://github.com/icebob/vue-form-generator/commit/acdbb6c))
* added missing "id" attributes to checkbox, checklist, radios and submit ([09d44c1](https://github.com/icebob/vue-form-generator/commit/09d44c1))
* added missing comma that failed in Travis ([32c7627](https://github.com/icebob/vue-form-generator/commit/32c7627))
* added styleClasses support to groups ([8b6801b](https://github.com/icebob/vue-form-generator/commit/8b6801b))
* addeds "styleClasses" to group schemas, reimplements #339 ([8e4b43d](https://github.com/icebob/vue-form-generator/commit/8e4b43d))
* bumped vue version to 2.5.3 ([7d7c0c4](https://github.com/icebob/vue-form-generator/commit/7d7c0c4))
* change the judgement ([d4bc27a](https://github.com/icebob/vue-form-generator/commit/d4bc27a))
* check if field.type is undefined before appending the "field-undefined" class ([9993550](https://github.com/icebob/vue-form-generator/commit/9993550))
* commit the built bundle ([45e1436](https://github.com/icebob/vue-form-generator/commit/45e1436))
* commit the built dist ([12b3cf7](https://github.com/icebob/vue-form-generator/commit/12b3cf7))
* commit without console.log ([79a77bd](https://github.com/icebob/vue-form-generator/commit/79a77bd))
* delete console.log ([ed853a2](https://github.com/icebob/vue-form-generator/commit/ed853a2))
* don't render labels when no label text is provided, proposed option 1 from #347 ([8ecc851](https://github.com/icebob/vue-form-generator/commit/8ecc851))
* fix bower.json validation ([2afb4ac](https://github.com/icebob/vue-form-generator/commit/2afb4ac))
* fixed null check ([7842b92](https://github.com/icebob/vue-form-generator/commit/7842b92))
* fixed Vue version ([624ed92](https://github.com/icebob/vue-form-generator/commit/624ed92))
* fixes #340 - "none" value set to `null`, formatValueToField checks for `isNil(value)` and returns `n ([5b42807](https://github.com/icebob/vue-form-generator/commit/5b42807)), closes [#340](https://github.com/icebob/vue-form-generator/issues/340)
* fixes #341 - introduced debounce functionality into `formatValueToModel` ([a46fe31](https://github.com/icebob/vue-form-generator/commit/a46fe31)), closes [#341](https://github.com/icebob/vue-form-generator/issues/341)
* fixes #345 - declare debouncedValidateFunc and set it when debouncedValidate() is called... vue 2.2. ([ee684f0](https://github.com/icebob/vue-form-generator/commit/ee684f0)), closes [#345](https://github.com/icebob/vue-form-generator/issues/345)
* fixes #358 - support "validateBeforeSubmit" with async validators ([5a26ef1](https://github.com/icebob/vue-form-generator/commit/5a26ef1)), closes [#358](https://github.com/icebob/vue-form-generator/issues/358)
* fixes #361 - use $event.target.valueAsNumber for number/range inputs, debounce `formatValueToModel`  ([d1a8bcf](https://github.com/icebob/vue-form-generator/commit/d1a8bcf)), closes [#361](https://github.com/icebob/vue-form-generator/issues/361)
* fixes #362 - `integer` validator now calls `number` validator, and returns `invalidIntegerl: "The va ([8d436be](https://github.com/icebob/vue-form-generator/commit/8d436be)), closes [#362](https://github.com/icebob/vue-form-generator/issues/362)
* Groupped fields "tag" param fixed. ([9275a26](https://github.com/icebob/vue-form-generator/commit/9275a26))
* moved unit test to formGenerator, as labels are managed by formGenerator and not the field component ([f102967](https://github.com/icebob/vue-form-generator/commit/f102967))
* remove garbage ([17eeae5](https://github.com/icebob/vue-form-generator/commit/17eeae5))
* remove the errorUnescaped property, add v-html on the error part ([ecd2ca5](https://github.com/icebob/vue-form-generator/commit/ecd2ca5))
* remove uniqueId import ([c86d7dc](https://github.com/icebob/vue-form-generator/commit/c86d7dc))
* removed commented out console.log statements ([e9bf285](https://github.com/icebob/vue-form-generator/commit/e9bf285))
* removed console.log and fixed quotes ([025b541](https://github.com/icebob/vue-form-generator/commit/025b541))
* removed indentation ([49f57b8](https://github.com/icebob/vue-form-generator/commit/49f57b8))
* requested by @icebob ([2724809](https://github.com/icebob/vue-form-generator/commit/2724809))
* reverted back to `schema.required` for "none selected" disabled state, per @icebob ([f562d7f](https://github.com/icebob/vue-form-generator/commit/f562d7f))
* reverting back to original test ([4ba3d4a](https://github.com/icebob/vue-form-generator/commit/4ba3d4a))
* Update badges ([705c6a7](https://github.com/icebob/vue-form-generator/commit/705c6a7))
* Update formGenerator.vue ([3208446](https://github.com/icebob/vue-form-generator/commit/3208446))
* update node-sass ([e3eee64](https://github.com/icebob/vue-form-generator/commit/e3eee64))
* Update README.md ([f57faba](https://github.com/icebob/vue-form-generator/commit/f57faba))
* Update README.md ([1092e01](https://github.com/icebob/vue-form-generator/commit/1092e01))
* Update README.md ([9d9701b](https://github.com/icebob/vue-form-generator/commit/9d9701b))
* updated tests for modified label logic ([f0c2281](https://github.com/icebob/vue-form-generator/commit/f0c2281))



<a name="2.1.1"></a>
## 2.1.1 (2017-10-20)

* :package: build ([42341a2](https://github.com/icebob/vue-form-generator/commit/42341a2))



<a name="2.1.0"></a>
# 2.1.0 (2017-10-20)

* :package: build ([a8eaf38](https://github.com/icebob/vue-form-generator/commit/a8eaf38))
* :package: Build ([c0b9007](https://github.com/icebob/vue-form-generator/commit/c0b9007))
* :package: Build ([e43baec](https://github.com/icebob/vue-form-generator/commit/e43baec))
* Add `validateDebounceTime` formOption to fix #309 ([20bbd59](https://github.com/icebob/vue-form-generator/commit/20bbd59)), closes [#309](https://github.com/icebob/vue-form-generator/issues/309)
* Add empty formatValueToField & formatValueToModel. Fix #308 #276 ([3353860](https://github.com/icebob/vue-form-generator/commit/3353860)), closes [#308](https://github.com/icebob/vue-form-generator/issues/308) [#276](https://github.com/icebob/vue-form-generator/issues/276)
* Add minlength attribute to input field ([f608113](https://github.com/icebob/vue-form-generator/commit/f608113))
* added css classes for core fields ([05a98eb](https://github.com/icebob/vue-form-generator/commit/05a98eb))
* bump version ([b8d5820](https://github.com/icebob/vue-form-generator/commit/b8d5820))
* checklist input name ([9c6c8d8](https://github.com/icebob/vue-form-generator/commit/9c6c8d8)), closes [#243](https://github.com/icebob/vue-form-generator/issues/243)
* Clarified css import instructions ([f1f6997](https://github.com/icebob/vue-form-generator/commit/f1f6997))
* Cleave field fixed. ([3aec9af](https://github.com/icebob/vue-form-generator/commit/3aec9af))
* Error options handled. ([7877bb7](https://github.com/icebob/vue-form-generator/commit/7877bb7))
* File input warning message fixed. ([c0ea9f7](https://github.com/icebob/vue-form-generator/commit/c0ea9f7))
* fix custom field import error ([22a3197](https://github.com/icebob/vue-form-generator/commit/22a3197))
* Fix lint. ([c4e4a52](https://github.com/icebob/vue-form-generator/commit/c4e4a52))
* Fix slugify. ([17aba74](https://github.com/icebob/vue-form-generator/commit/17aba74))
* Fix syntax error in template. ([19cb7bb](https://github.com/icebob/vue-form-generator/commit/19cb7bb))
* Fixed #234 ([42b4fcb](https://github.com/icebob/vue-form-generator/commit/42b4fcb)), closes [#234](https://github.com/icebob/vue-form-generator/issues/234)
* fixed missing semi-colon ([e4c6093](https://github.com/icebob/vue-form-generator/commit/e4c6093))
* fixed pug syntax ([b4bf14e](https://github.com/icebob/vue-form-generator/commit/b4bf14e))
* Group options in function value. ([15344d7](https://github.com/icebob/vue-form-generator/commit/15344d7))
* hint ([a8f09ae](https://github.com/icebob/vue-form-generator/commit/a8f09ae))
* Hint ([4fe380e](https://github.com/icebob/vue-form-generator/commit/4fe380e))
* Hint test ([e637c60](https://github.com/icebob/vue-form-generator/commit/e637c60))
* Improve onChange in file field. ([b0baf00](https://github.com/icebob/vue-form-generator/commit/b0baf00))
* Input type range now return a `Number` ([8d891d2](https://github.com/icebob/vue-form-generator/commit/8d891d2))
* Missing semicolon fixed. ([fec34f4](https://github.com/icebob/vue-form-generator/commit/fec34f4))
* New field: file upload (fieldFile). ([5b74ead](https://github.com/icebob/vue-form-generator/commit/5b74ead))
* refactored  to ([db63f91](https://github.com/icebob/vue-form-generator/commit/db63f91))
* Refinement ([89ee169](https://github.com/icebob/vue-form-generator/commit/89ee169))
* Refinement ([daefe38](https://github.com/icebob/vue-form-generator/commit/daefe38))
* removed unnecessary semi-colon to fix travis ([076f0e8](https://github.com/icebob/vue-form-generator/commit/076f0e8))
* Rename fieldFile to fieldUpload. ([9bfbb4e](https://github.com/icebob/vue-form-generator/commit/9bfbb4e))
* Syntax error fix. ([6a171e3](https://github.com/icebob/vue-form-generator/commit/6a171e3))
* Test 1. version. ([cacf34f](https://github.com/icebob/vue-form-generator/commit/cacf34f))
* Test fixed. ([98bc6b6](https://github.com/icebob/vue-form-generator/commit/98bc6b6))
* update changelog ([426cee9](https://github.com/icebob/vue-form-generator/commit/426cee9))
* Update selection field with group options. ([07bbb07](https://github.com/icebob/vue-form-generator/commit/07bbb07))
* Use `name` in checklist input fields with slugify. Fix #243 ([a60c0db](https://github.com/icebob/vue-form-generator/commit/a60c0db)), closes [#243](https://github.com/icebob/vue-form-generator/issues/243)
* Use selectOptions in selectEx ([fa2acf1](https://github.com/icebob/vue-form-generator/commit/fa2acf1))



<a name="2.0.0"></a>
# 2.0.0 (2017-06-30)

* :package: build ([c21f97e](https://github.com/icebob/vue-form-generator/commit/c21f97e))
* :package: Build v2 stable ([f7043b6](https://github.com/icebob/vue-form-generator/commit/f7043b6))
* # Please enter the commit message for your changes. Lines starting ([2009272](https://github.com/icebob/vue-form-generator/commit/2009272))
* Add an option to hide the none selected text ([b4d2b34](https://github.com/icebob/vue-form-generator/commit/b4d2b34))
* add license badge ([c30cbbf](https://github.com/icebob/vue-form-generator/commit/c30cbbf))
* Add missing option ([324c0e6](https://github.com/icebob/vue-form-generator/commit/324c0e6))
* bump version to v2 stable ([b84211e](https://github.com/icebob/vue-form-generator/commit/b84211e))
* create picker dev ([47d9d57](https://github.com/icebob/vue-form-generator/commit/47d9d57))
* eslint fixes ([11763e3](https://github.com/icebob/vue-form-generator/commit/11763e3))
* fix #138. Add format to date inputs ([c82cd9a](https://github.com/icebob/vue-form-generator/commit/c82cd9a)), closes [#138](https://github.com/icebob/vue-form-generator/issues/138)
* Fix dev ([ab31578](https://github.com/icebob/vue-form-generator/commit/ab31578))
* Fix problem with comments and update test ([155f5a1](https://github.com/icebob/vue-form-generator/commit/155f5a1))
* update multiselect ver ([181aa06](https://github.com/icebob/vue-form-generator/commit/181aa06))
* Update the options for the v2 of multiselect ([c868aab](https://github.com/icebob/vue-form-generator/commit/c868aab))



<a name="2.0.0-beta8"></a>
# 2.0.0-beta8 (2017-06-01)

* :package: build ([938f112](https://github.com/icebob/vue-form-generator/commit/938f112))
* :package: build ([076b7f0](https://github.com/icebob/vue-form-generator/commit/076b7f0))
* Add access to click event on buttons ([d949421](https://github.com/icebob/vue-form-generator/commit/d949421))
* bump version ([67bd717](https://github.com/icebob/vue-form-generator/commit/67bd717))
* fix #218 ([b632f1b](https://github.com/icebob/vue-form-generator/commit/b632f1b)), closes [#218](https://github.com/icebob/vue-form-generator/issues/218)
* fix webpack core css filename ([ba48329](https://github.com/icebob/vue-form-generator/commit/ba48329))
* update changelog ([cabc1e4](https://github.com/icebob/vue-form-generator/commit/cabc1e4))



<a name="2.0.0-beta7"></a>
# 2.0.0-beta7 (2017-05-31)

* :package: build ([71e9eb4](https://github.com/icebob/vue-form-generator/commit/71e9eb4))
* :package: build ([908100e](https://github.com/icebob/vue-form-generator/commit/908100e))
* :package: build ([5105f39](https://github.com/icebob/vue-form-generator/commit/5105f39))
* [BUGFIX] Fieldset in proper place un puq template ([79c0852](https://github.com/icebob/vue-form-generator/commit/79c0852))
* [BUGFIX] vue-form-gerenator class in wrapper div ([b5d58ac](https://github.com/icebob/vue-form-generator/commit/b5d58ac))
* [FEATURE] Groups ([613e831](https://github.com/icebob/vue-form-generator/commit/613e831))
* Add a props to change the main tag ([90b0767](https://github.com/icebob/vue-form-generator/commit/90b0767))
* Add support for schema.legend & field id prefixes ([a6165c8](https://github.com/icebob/vue-form-generator/commit/a6165c8))
* Add unit test for vueFormGenerator.fieldTypeHasLabel ([c61b941](https://github.com/icebob/vue-form-generator/commit/c61b941))
* Added props validation for "tag" and unit test for it. ([c728597](https://github.com/icebob/vue-form-generator/commit/c728597))
* Added tests for abstractField.getFieldID() ([492514d](https://github.com/icebob/vue-form-generator/commit/492514d))
* bump version ([5a30f87](https://github.com/icebob/vue-form-generator/commit/5a30f87))
* fix checklist validation bug #194 ([bea085f](https://github.com/icebob/vue-form-generator/commit/bea085f)), closes [#194](https://github.com/icebob/vue-form-generator/issues/194)
* fix lints ([890ed44](https://github.com/icebob/vue-form-generator/commit/890ed44))
* fix schema.fields error ([d2b67e0](https://github.com/icebob/vue-form-generator/commit/d2b67e0))
* fix tests & layout for fields ([ee5ed30](https://github.com/icebob/vue-form-generator/commit/ee5ed30))
* fixed indentation ([425faa2](https://github.com/icebob/vue-form-generator/commit/425faa2))
* Implement #199 ([547ea2e](https://github.com/icebob/vue-form-generator/commit/547ea2e))
* Make fieldTypeHasLabel test actually work & test default path ([d618958](https://github.com/icebob/vue-form-generator/commit/d618958))
* remove .sync ([d008869](https://github.com/icebob/vue-form-generator/commit/d008869))
* remove tag from groups ([b4dc972](https://github.com/icebob/vue-form-generator/commit/b4dc972))
* rename `options` to `formOptions` because conflicted with vueMultiSelect property ([2f29943](https://github.com/icebob/vue-form-generator/commit/2f29943))
* rename example & improve code ([caa4124](https://github.com/icebob/vue-form-generator/commit/caa4124))
* Support bootstrap columns on fields ([fc2d47a](https://github.com/icebob/vue-form-generator/commit/fc2d47a))
* Support custom validation classes ([378a2a7](https://github.com/icebob/vue-form-generator/commit/378a2a7))



<a name="2.0.0-beta6"></a>
# 2.0.0-beta6 (2017-04-04)

* :package: build ([4f2cabe](https://github.com/icebob/vue-form-generator/commit/4f2cabe))
* :package: build ([dd33ea0](https://github.com/icebob/vue-form-generator/commit/dd33ea0))
* #159 Fix customLabel function from multi-select field to work with object values ([84d3e41](https://github.com/icebob/vue-form-generator/commit/84d3e41))
* #172 Sync model value with files from file upload input ([4ac96e4](https://github.com/icebob/vue-form-generator/commit/4ac96e4))
* `checklist` field now support array of string or array of objects (with `name` and `value` propertie ([be09146](https://github.com/icebob/vue-form-generator/commit/be09146))
* `radios` field now support array of string or array of objects (with `name` and `value` properties)  ([0f48c30](https://github.com/icebob/vue-form-generator/commit/0f48c30))
* add `.locale` method to every validator ([1dc7fb7](https://github.com/icebob/vue-form-generator/commit/1dc7fb7))
* Add a `is-checked` class to element where the input is checked to ease customisation. Add checklist  ([3facc08](https://github.com/icebob/vue-form-generator/commit/3facc08))
* add example to dev ([267073c](https://github.com/icebob/vue-form-generator/commit/267073c))
* add test for async validator ([e9463c2](https://github.com/icebob/vue-form-generator/commit/e9463c2))
* bump version ([8ced4af](https://github.com/icebob/vue-form-generator/commit/8ced4af))
* change `input` event to `change` on checlist field ([e6a2b9a](https://github.com/icebob/vue-form-generator/commit/e6a2b9a))
* Change `onChange` trigger event from `change` to `input` for `checklist` ([67a3659](https://github.com/icebob/vue-form-generator/commit/67a3659))
* fix #174 ([d939c95](https://github.com/icebob/vue-form-generator/commit/d939c95)), closes [#174](https://github.com/icebob/vue-form-generator/issues/174)
* Fix a problem with value define but not an Array ([190f67a](https://github.com/icebob/vue-form-generator/commit/190f67a))
* fix double validator ([7c6d658](https://github.com/icebob/vue-form-generator/commit/7c6d658))
* Fix error "TypeError: this.value.push is not a function" in `checklist` ([c66b0e9](https://github.com/icebob/vue-form-generator/commit/c66b0e9))
* fix lint ([1f99ab6](https://github.com/icebob/vue-form-generator/commit/1f99ab6))
* fix parameters of validators ([d97c917](https://github.com/icebob/vue-form-generator/commit/d97c917))
* Fix test to reflect changes ([6126f25](https://github.com/icebob/vue-form-generator/commit/6126f25))
* fix usage example in readme ([596b302](https://github.com/icebob/vue-form-generator/commit/596b302))
* Fix validator messages interpolation ([6b44e39](https://github.com/icebob/vue-form-generator/commit/6b44e39))
* Improve readme file. ([846cf15](https://github.com/icebob/vue-form-generator/commit/846cf15))
* Move some dependency to devDependency ([b00e4bb](https://github.com/icebob/vue-form-generator/commit/b00e4bb))
* Provides ability to use strings as validators ([36c7829](https://github.com/icebob/vue-form-generator/commit/36c7829))
* remove only from test ([560d234](https://github.com/icebob/vue-form-generator/commit/560d234))
* simplify code ([cd922ee](https://github.com/icebob/vue-form-generator/commit/cd922ee))
* support async (promised) validators #170 ([d50a756](https://github.com/icebob/vue-form-generator/commit/d50a756))
* update changelog ([385b7be](https://github.com/icebob/vue-form-generator/commit/385b7be))
* update code language in readme ([3ee0865](https://github.com/icebob/vue-form-generator/commit/3ee0865))
* Update the unit test to reflect the changes and test for the new behavior. Fix lint error. ([1f6150f](https://github.com/icebob/vue-form-generator/commit/1f6150f))
* Update unit test for `checklist` ([24eb17f](https://github.com/icebob/vue-form-generator/commit/24eb17f))
* Update unit test for `radios` ([8a94e81](https://github.com/icebob/vue-form-generator/commit/8a94e81))
* Use `this.$set` instead of a direct assignation ([4b7e118](https://github.com/icebob/vue-form-generator/commit/4b7e118))



<a name="2.0.0-beta5"></a>
# 2.0.0-beta5 (2017-03-01)

* :package: build ([dfee906](https://github.com/icebob/vue-form-generator/commit/dfee906))
* :package: build ([0629b89](https://github.com/icebob/vue-form-generator/commit/0629b89))
* :package: build ([15bf501](https://github.com/icebob/vue-form-generator/commit/15bf501))
* :package: build ([e87756c](https://github.com/icebob/vue-form-generator/commit/e87756c))
* :package: build ([147ecc0](https://github.com/icebob/vue-form-generator/commit/147ecc0))
* :package: build beta5 ([a878aac](https://github.com/icebob/vue-form-generator/commit/a878aac))
* add `on-validated` event to formGenerator ([369b69f](https://github.com/icebob/vue-form-generator/commit/369b69f))
* add yarn cache to travis ([025563c](https://github.com/icebob/vue-form-generator/commit/025563c))
* bump version ([5dc24c4](https://github.com/icebob/vue-form-generator/commit/5dc24c4))
* change name to "vfg" instead of "vue-form-generator" for the exported files. ([11303d4](https://github.com/icebob/vue-form-generator/commit/11303d4))
* Change template from jade to pug ([7e61a57](https://github.com/icebob/vue-form-generator/commit/7e61a57))
* fix #130 ([01ff885](https://github.com/icebob/vue-form-generator/commit/01ff885)), closes [#130](https://github.com/icebob/vue-form-generator/issues/130)
* Fix #137 (number input validation) ([22ac59e](https://github.com/icebob/vue-form-generator/commit/22ac59e)), closes [#137](https://github.com/icebob/vue-form-generator/issues/137)
* Fix `this` in schema functions ([356241b](https://github.com/icebob/vue-form-generator/commit/356241b))
* fix examples ([5ffcf20](https://github.com/icebob/vue-form-generator/commit/5ffcf20))
* fix main in bower ([2d77337](https://github.com/icebob/vue-form-generator/commit/2d77337))
* fix onChanged event in abstractField ([69d2f76](https://github.com/icebob/vue-form-generator/commit/69d2f76))
* fix some test ([8db23f8](https://github.com/icebob/vue-form-generator/commit/8db23f8))
* fix submit button issues ([d2e3b07](https://github.com/icebob/vue-form-generator/commit/d2e3b07))
* fix template of errors ([94a2199](https://github.com/icebob/vue-form-generator/commit/94a2199))
* Fix use of moment.js to fecha in dev ([928da35](https://github.com/icebob/vue-form-generator/commit/928da35))
* fixed some test after #120 ([ba4be42](https://github.com/icebob/vue-form-generator/commit/ba4be42)), closes [#120](https://github.com/icebob/vue-form-generator/issues/120)
* ignore typings ([736a646](https://github.com/icebob/vue-form-generator/commit/736a646))
* remove comment ([245f3d5](https://github.com/icebob/vue-form-generator/commit/245f3d5))
* remove console log ([a8d5e43](https://github.com/icebob/vue-form-generator/commit/a8d5e43))
* remove travis cache ([67a2128](https://github.com/icebob/vue-form-generator/commit/67a2128))
* remove unused dep ([dc08fbf](https://github.com/icebob/vue-form-generator/commit/dc08fbf))
* remove unused deps ([ddb1efd](https://github.com/icebob/vue-form-generator/commit/ddb1efd))
* rename `on-validated` to `validated` ([5b8bd23](https://github.com/icebob/vue-form-generator/commit/5b8bd23))
* reupdate deps ([a21532b](https://github.com/icebob/vue-form-generator/commit/a21532b))
* revert karma update ([67e79c3](https://github.com/icebob/vue-form-generator/commit/67e79c3))
* rewrite field validate ([0f83624](https://github.com/icebob/vue-form-generator/commit/0f83624))
* Separation of the bundle into "core" fields and "optional" fields ([e98e23e](https://github.com/icebob/vue-form-generator/commit/e98e23e))
* Small changes to npm script and removed console.warn ([3011bb8](https://github.com/icebob/vue-form-generator/commit/3011bb8))
* some comments ([19ecdbb](https://github.com/icebob/vue-form-generator/commit/19ecdbb))
* test field validate event ([e3a31cf](https://github.com/icebob/vue-form-generator/commit/e3a31cf))
* travis yarn to npm ([142d7b1](https://github.com/icebob/vue-form-generator/commit/142d7b1))
* try yarn without cache ([08f545b](https://github.com/icebob/vue-form-generator/commit/08f545b))
* update changelog ([6264ab0](https://github.com/icebob/vue-form-generator/commit/6264ab0))
* update deps ([4b2e1f7](https://github.com/icebob/vue-form-generator/commit/4b2e1f7))
* update readme #123 ([a3d8e7e](https://github.com/icebob/vue-form-generator/commit/a3d8e7e))



<a name="2.0.0-beta4"></a>
# 2.0.0-beta4 (2017-02-15)

* :package: build ([ade96b4](https://github.com/icebob/vue-form-generator/commit/ade96b4))
* :package: build ([0f8aea5](https://github.com/icebob/vue-form-generator/commit/0f8aea5))
* :package: build ([0c84de0](https://github.com/icebob/vue-form-generator/commit/0c84de0))
* :package: build ([a69e244](https://github.com/icebob/vue-form-generator/commit/a69e244))
* :package: build ([3f25fca](https://github.com/icebob/vue-form-generator/commit/3f25fca))
* :package: build ([9f707dc](https://github.com/icebob/vue-form-generator/commit/9f707dc))
* #112 Get rid of Vue dependency in the code. ([01fa81b](https://github.com/icebob/vue-form-generator/commit/01fa81b))
* add fecha ([4751917](https://github.com/icebob/vue-form-generator/commit/4751917))
* add fecha instead of moment ([dcaa273](https://github.com/icebob/vue-form-generator/commit/dcaa273))
* add lodash babel plugin ([8dce56d](https://github.com/icebob/vue-form-generator/commit/8dce56d))
* Amend error message for vue-multi-select ([dc0ace9](https://github.com/icebob/vue-form-generator/commit/dc0ace9))
* bump version ([ede7fd8](https://github.com/icebob/vue-form-generator/commit/ede7fd8))
* fix dateTimePicker ([53d3867](https://github.com/icebob/vue-form-generator/commit/53d3867))
* fix dev example ([ecd812f](https://github.com/icebob/vue-form-generator/commit/ecd812f))
* fix dev example ([8be80aa](https://github.com/icebob/vue-form-generator/commit/8be80aa))
* fix eslint restspread error ([cc7a436](https://github.com/icebob/vue-form-generator/commit/cc7a436))
* fix fieldImage url if undefined ([d199677](https://github.com/icebob/vue-form-generator/commit/d199677))
* fix model-changed event value ([364a1ce](https://github.com/icebob/vue-form-generator/commit/364a1ce))
* fix pikaday ([e7589b3](https://github.com/icebob/vue-form-generator/commit/e7589b3))
* fix unreactive model sets (again) ([2bef826](https://github.com/icebob/vue-form-generator/commit/2bef826))
* handle null value ([97213a8](https://github.com/icebob/vue-form-generator/commit/97213a8))
* remove skip from pikaday tests ([39ce4c6](https://github.com/icebob/vue-form-generator/commit/39ce4c6))
* remove unused comment ([8c47cf9](https://github.com/icebob/vue-form-generator/commit/8c47cf9))
* remove unused comments ([c61ab6b](https://github.com/icebob/vue-form-generator/commit/c61ab6b))
* update changelog ([3f1848f](https://github.com/icebob/vue-form-generator/commit/3f1848f))
* update datetimepicker version ([d3faf1c](https://github.com/icebob/vue-form-generator/commit/d3faf1c))
* Update README.md ([2095c08](https://github.com/icebob/vue-form-generator/commit/2095c08))
* Update README.md ([b095166](https://github.com/icebob/vue-form-generator/commit/b095166))
* update year ([afe5e74](https://github.com/icebob/vue-form-generator/commit/afe5e74))



<a name="2.0.0-beta3"></a>
# 2.0.0-beta3 (2017-02-10)

* :package: build ([dfe78a0](https://github.com/icebob/vue-form-generator/commit/dfe78a0))
* :pencil: update changelog ([cfe892f](https://github.com/icebob/vue-form-generator/commit/cfe892f))
* bump version ([665d6c1](https://github.com/icebob/vue-form-generator/commit/665d6c1))
* fix nested models ([3e8d1a1](https://github.com/icebob/vue-form-generator/commit/3e8d1a1))
* remove unused codes ([ce999d0](https://github.com/icebob/vue-form-generator/commit/ce999d0))
* update changelog ([8636178](https://github.com/icebob/vue-form-generator/commit/8636178))



<a name="2.0.0-beta2"></a>
# 2.0.0-beta2 (2017-01-30)

* :bug: fix examples ([b8c82c0](https://github.com/icebob/vue-form-generator/commit/b8c82c0))
* :bug: fix examples ([86d2ef4](https://github.com/icebob/vue-form-generator/commit/86d2ef4))
* :package: Build beta2 ([ab562bd](https://github.com/icebob/vue-form-generator/commit/ab562bd))
* Add support for readonly and featured field functions ([065d0a7](https://github.com/icebob/vue-form-generator/commit/065d0a7))
* Allow form fields required state to be controlled with a function, ([e08dbbb](https://github.com/icebob/vue-form-generator/commit/e08dbbb))
* Better label support for more inputs: ([c727d7a](https://github.com/icebob/vue-form-generator/commit/c727d7a))
* bump version to 2.0.0-beta2 ([94347e7](https://github.com/icebob/vue-form-generator/commit/94347e7))
* fix checkbox tests ([593307b](https://github.com/icebob/vue-form-generator/commit/593307b))
* Fix eslint errors ([6cfde46](https://github.com/icebob/vue-form-generator/commit/6cfde46))
* Fix some CSS visual bugs ([7a786f7](https://github.com/icebob/vue-form-generator/commit/7a786f7))
* fix some errors ([8d3ca97](https://github.com/icebob/vue-form-generator/commit/8d3ca97))
* Fix vue version in examples ([ebfc4b0](https://github.com/icebob/vue-form-generator/commit/ebfc4b0))
* fix vue-multiselect test errors ([2aacb57](https://github.com/icebob/vue-form-generator/commit/2aacb57))
* Improve labels for better accessibility: ([0e2c41c](https://github.com/icebob/vue-form-generator/commit/0e2c41c))
* remove console.log ([454fa0e](https://github.com/icebob/vue-form-generator/commit/454fa0e))
* remove v4 from travis ([bbdcc0f](https://github.com/icebob/vue-form-generator/commit/bbdcc0f))
* reorganize dev codes ([386fa3f](https://github.com/icebob/vue-form-generator/commit/386fa3f))
* Undo the local port number change for the dev server ([2a17ce6](https://github.com/icebob/vue-form-generator/commit/2a17ce6))
* update deps ([f4e5709](https://github.com/icebob/vue-form-generator/commit/f4e5709))
* update readme ([eb6328c](https://github.com/icebob/vue-form-generator/commit/eb6328c))
* Update README.md ([ea91365](https://github.com/icebob/vue-form-generator/commit/ea91365))
* update travis. Remove v5, add v7 ([1d85539](https://github.com/icebob/vue-form-generator/commit/1d85539))
* update yarn lock ([e57725c](https://github.com/icebob/vue-form-generator/commit/e57725c))
* update yarn lock ([df5aca0](https://github.com/icebob/vue-form-generator/commit/df5aca0))



<a name="2.0.0-beta1"></a>
# 2.0.0-beta1 (2016-12-12)

* docs: changelog updated ([9334ce6](https://github.com/icebob/vue-form-generator/commit/9334ce6))
* :bug: fix $index ([80ecf31](https://github.com/icebob/vue-form-generator/commit/80ecf31))
* :bug: fix examples ([8ab6894](https://github.com/icebob/vue-form-generator/commit/8ab6894))
* :package: first build for Vue 2.x ([393461b](https://github.com/icebob/vue-form-generator/commit/393461b))
* Fix a bug with v-model and dynamic type on input. ([1d090df](https://github.com/icebob/vue-form-generator/commit/1d090df))
* fix validator error ([d671057](https://github.com/icebob/vue-form-generator/commit/d671057))
* Update README.md ([52c1cb6](https://github.com/icebob/vue-form-generator/commit/52c1cb6))
* Update README.md ([acd1e22](https://github.com/icebob/vue-form-generator/commit/acd1e22))
* Update vuejs version to 2.1.3, and made change accordingly (added vue-template-compiler). Update vue ([61b76c1](https://github.com/icebob/vue-form-generator/commit/61b76c1))
* test: fix checklist tests ([f3202fa](https://github.com/icebob/vue-form-generator/commit/f3202fa))
* test: fix fieldCleave tests ([caae630](https://github.com/icebob/vue-form-generator/commit/caae630))
* test: fix selectEx tests ([b240183](https://github.com/icebob/vue-form-generator/commit/b240183))
* test: fix test cases ([8044f9e](https://github.com/icebob/vue-form-generator/commit/8044f9e))



<a name="0.6.1"></a>
## 0.6.1 (2016-11-28)

* docs: update changelog ([853228d](https://github.com/icebob/vue-form-generator/commit/853228d))
* :package: Build v0.6.1 ([79580a2](https://github.com/icebob/vue-form-generator/commit/79580a2))
* Add missing opening brace ([6842f1b](https://github.com/icebob/vue-form-generator/commit/6842f1b))
* bump version ([1976b4a](https://github.com/icebob/vue-form-generator/commit/1976b4a))
* Fixed bower file syntax error #98 ([06b0022](https://github.com/icebob/vue-form-generator/commit/06b0022)), closes [#98](https://github.com/icebob/vue-form-generator/issues/98)



<a name="0.6.0"></a>
# 0.6.0 (2016-11-14)

* docs: fix npms.io badge url ([475eb91](https://github.com/icebob/vue-form-generator/commit/475eb91))
* docs: update changelog ([6bd9c78](https://github.com/icebob/vue-form-generator/commit/6bd9c78))
* :bug: Fix options prop default #91 ([3d2e821](https://github.com/icebob/vue-form-generator/commit/3d2e821)), closes [#91](https://github.com/icebob/vue-form-generator/issues/91)
* :package: build ([51abcca](https://github.com/icebob/vue-form-generator/commit/51abcca))
* :package: Build ([ce72dc4](https://github.com/icebob/vue-form-generator/commit/ce72dc4))
* :package: bump version & build ([d56f93c](https://github.com/icebob/vue-form-generator/commit/d56f93c))
* [wip] modification to work with vuejs 2.0. ([0b1df2c](https://github.com/icebob/vue-form-generator/commit/0b1df2c))
* add bower ([ce44822](https://github.com/icebob/vue-form-generator/commit/ce44822))
* add number prop to input field ([a40e23c](https://github.com/icebob/vue-form-generator/commit/a40e23c))
* add step attribute to number field #92 ([ce64c4e](https://github.com/icebob/vue-form-generator/commit/ce64c4e))
* Fix #82 ([7a83777](https://github.com/icebob/vue-form-generator/commit/7a83777)), closes [#82](https://github.com/icebob/vue-form-generator/issues/82)
* Fix #84 ([2c36001](https://github.com/icebob/vue-form-generator/commit/2c36001)), closes [#84](https://github.com/icebob/vue-form-generator/issues/84)
* Fix #84 ([58093c7](https://github.com/icebob/vue-form-generator/commit/58093c7)), closes [#84](https://github.com/icebob/vue-form-generator/issues/84)
* fix lints ([1f8f3d9](https://github.com/icebob/vue-form-generator/commit/1f8f3d9))
* quick fix for #85 ([cad76da](https://github.com/icebob/vue-form-generator/commit/cad76da)), closes [#85](https://github.com/icebob/vue-form-generator/issues/85)
* remote customLabel prop from multiselect because give errors ([5dfc5bb](https://github.com/icebob/vue-form-generator/commit/5dfc5bb))
* remove commit message package ([682c6ab](https://github.com/icebob/vue-form-generator/commit/682c6ab))
* Update README.md ([8128a52](https://github.com/icebob/vue-form-generator/commit/8128a52))
* test: add test to #82 ([aefdbac](https://github.com/icebob/vue-form-generator/commit/aefdbac))
* test: lock multiselect version ([5b0a4d0](https://github.com/icebob/vue-form-generator/commit/5b0a4d0))
* fix: aligned with issue #84 ([5d6c0c7](https://github.com/icebob/vue-form-generator/commit/5d6c0c7))
* fix: customLabel return a basic function when undefined instead of null ([9b3d51d](https://github.com/icebob/vue-form-generator/commit/9b3d51d))
* fix: rewrite in jade and commenting problematic fields ([35be49e](https://github.com/icebob/vue-form-generator/commit/35be49e))
* bug: fix quotes ([13d6e0f](https://github.com/icebob/vue-form-generator/commit/13d6e0f))
* new: add form POST example ([08412c7](https://github.com/icebob/vue-form-generator/commit/08412c7))



<a name="0.5.0"></a>
# 0.5.0 (2016-09-28)

* docs: commenting methods ([0d7848e](https://github.com/icebob/vue-form-generator/commit/0d7848e))
* docs: commenting methods ([dc17006](https://github.com/icebob/vue-form-generator/commit/dc17006))
* docs: remove TODOS from readme ([76aeb52](https://github.com/icebob/vue-form-generator/commit/76aeb52))
* docs: update changelog ([3f0db9f](https://github.com/icebob/vue-form-generator/commit/3f0db9f))
* :bug: fix: Fixed #75 ([f8db7b0](https://github.com/icebob/vue-form-generator/commit/f8db7b0)), closes [#75](https://github.com/icebob/vue-form-generator/issues/75)
* :package: build ([af75ebc](https://github.com/icebob/vue-form-generator/commit/af75ebc))
* :package: Build v.0.5.0 ([b67ada9](https://github.com/icebob/vue-form-generator/commit/b67ada9))
* Add dynamic class to help styling of the noUiSlider field ([2ce1938](https://github.com/icebob/vue-form-generator/commit/2ce1938))
* add test for radios field and update schema ([07605c1](https://github.com/icebob/vue-form-generator/commit/07605c1))
* Bump version to v0.5.0 ([14b34be](https://github.com/icebob/vue-form-generator/commit/14b34be))
* code maintenance ([307e903](https://github.com/icebob/vue-form-generator/commit/307e903))
* creation of two computed value to avoid a warning from Vue in noUiSlider field ([6f5b71d](https://github.com/icebob/vue-form-generator/commit/6f5b71d))
* fix #71 format value to properly interact with model and other fields ([b48c7f1](https://github.com/icebob/vue-form-generator/commit/b48c7f1)), closes [#71](https://github.com/icebob/vue-form-generator/issues/71)
* fix linting ([4bc0601](https://github.com/icebob/vue-form-generator/commit/4bc0601))
* format date related fields values ([cf2f577](https://github.com/icebob/vue-form-generator/commit/cf2f577))
* hideInput prop in dev schema ([b68f94f](https://github.com/icebob/vue-form-generator/commit/b68f94f))
* Implement #78 ([f92b193](https://github.com/icebob/vue-form-generator/commit/f92b193))
* rename dateTime to dateTimePicker and slider to rangeSlider ([5830e85](https://github.com/icebob/vue-form-generator/commit/5830e85))
* rename field html5 to input ([323968e](https://github.com/icebob/vue-form-generator/commit/323968e))
* rename sliderOptions to noUiSliderOptions to follow schema logic ([7f4afa9](https://github.com/icebob/vue-form-generator/commit/7f4afa9))
* update dependencies #79 ([7298080](https://github.com/icebob/vue-form-generator/commit/7298080))
* Update README.md ([f70b5e8](https://github.com/icebob/vue-form-generator/commit/f70b5e8))
* Update README.md ([7d89746](https://github.com/icebob/vue-form-generator/commit/7d89746))
* Update README.md ([a8ec66e](https://github.com/icebob/vue-form-generator/commit/a8ec66e))
* update schema ([bce9070](https://github.com/icebob/vue-form-generator/commit/bce9070))
* Update schema and data for dev ([4c76f21](https://github.com/icebob/vue-form-generator/commit/4c76f21))
* update schema and fix a test ([b97c6bd](https://github.com/icebob/vue-form-generator/commit/b97c6bd))
* fix: check value correspond to selected value ([b00e777](https://github.com/icebob/vue-form-generator/commit/b00e777))
* fix: fix Codacy issues ([deb50b6](https://github.com/icebob/vue-form-generator/commit/deb50b6))
* fix: forgot the new method getStartValue() ([13b74e3](https://github.com/icebob/vue-form-generator/commit/13b74e3))
* fix: missing closing bracket ([42c42b0](https://github.com/icebob/vue-form-generator/commit/42c42b0))
* fix: moment import ([ebf7484](https://github.com/icebob/vue-form-generator/commit/ebf7484))
* fix: remove console.log ([7cf484a](https://github.com/icebob/vue-form-generator/commit/7cf484a))
* new: hideInput prop in fieldImage #77 ([deb4ec5](https://github.com/icebob/vue-form-generator/commit/deb4ec5))
* new: new "radios" field ([7106394](https://github.com/icebob/vue-form-generator/commit/7106394))
* new: new field html5 input ([5189b99](https://github.com/icebob/vue-form-generator/commit/5189b99))
* test: add attr checker to switch field ([2ed434e](https://github.com/icebob/vue-form-generator/commit/2ed434e))
* test: add file input attr test ([352fb20](https://github.com/icebob/vue-form-generator/commit/352fb20))
* test: attr test to submit field ([1627c71](https://github.com/icebob/vue-form-generator/commit/1627c71))
* test: deactivate a unit test. Add a better check to avoid "undefined" warning on a condition. ([4afccd3](https://github.com/icebob/vue-form-generator/commit/4afccd3))
* enhancement: staticMap updated with more options for more flexibility. Test updated to reflect chang ([65c8ac2](https://github.com/icebob/vue-form-generator/commit/65c8ac2))



<a name="0.4.1"></a>
## 0.4.1 (2016-09-08)

* docs: update changelog ([67ed6f3](https://github.com/icebob/vue-form-generator/commit/67ed6f3))
* :arrow_up: change fontawesome help icon to img #61 ([70baca6](https://github.com/icebob/vue-form-generator/commit/70baca6))
* :bug: bug: "Invalid date" message in pikaday field. Change dev schema for a simple one. Delete defau ([a45188a](https://github.com/icebob/vue-form-generator/commit/a45188a))
* :package: build ([60dda5f](https://github.com/icebob/vue-form-generator/commit/60dda5f))
* :package: build ([2e94d52](https://github.com/icebob/vue-form-generator/commit/2e94d52))
* :package: Build v0.4.1 ([9fee72a](https://github.com/icebob/vue-form-generator/commit/9fee72a))
* :white_check_mark: test: add test to custom field ([80d1025](https://github.com/icebob/vue-form-generator/commit/80d1025))
* Bump version to v0.4.1 ([4e0e031](https://github.com/icebob/vue-form-generator/commit/4e0e031))
* support custom fields & example #62 ([e61824a](https://github.com/icebob/vue-form-generator/commit/e61824a))
* fix: change test depending on changes ([c645cea](https://github.com/icebob/vue-form-generator/commit/c645cea))
* fix: re-added placeholder in field password and number (and corresponding test) ([79bfee6](https://github.com/icebob/vue-form-generator/commit/79bfee6))
* fix: remove comment, trailing space and duplicate from tests ([e618253](https://github.com/icebob/vue-form-generator/commit/e618253))
* fix: remove readonly attribute on select element ([2e5e16b](https://github.com/icebob/vue-form-generator/commit/2e5e16b))
* fix: remove useless attributes ([5745318](https://github.com/icebob/vue-form-generator/commit/5745318))
* fix: update of attributes of Checklist, Text and Textarea fields. ([ce3a91c](https://github.com/icebob/vue-form-generator/commit/ce3a91c))
* test: update to many test to check optional attributes ([ebf3f01](https://github.com/icebob/vue-form-generator/commit/ebf3f01))
* dev: remove console log ([3ffeef1](https://github.com/icebob/vue-form-generator/commit/3ffeef1))
* enhancement: add minlength attribute to textarea ([a7e39d9](https://github.com/icebob/vue-form-generator/commit/a7e39d9))
* enhancement: add missing "autocomplete", "placeholder" and "readonly" attr to input fields. Ordered  ([f5af70c](https://github.com/icebob/vue-form-generator/commit/f5af70c))



<a name="0.4.0"></a>
# 0.4.0 (2016-08-30)

* noUISlider: minor changes ([1f22d80](https://github.com/icebob/vue-form-generator/commit/1f22d80))
* docs: update changelog ([672e656](https://github.com/icebob/vue-form-generator/commit/672e656))
* fix: add a .jsbeautify to help with linting ([acfa264](https://github.com/icebob/vue-form-generator/commit/acfa264))
* fix: add disabled option to noUiSlider field ([c169cb3](https://github.com/icebob/vue-form-generator/commit/c169cb3))
* fix: add disabled option to noUiSlider field ([6d10687](https://github.com/icebob/vue-form-generator/commit/6d10687))
* fix: added missing options for VueMultiselect. Removed `min` from dev schema (not used). ([a9bb8ae](https://github.com/icebob/vue-form-generator/commit/a9bb8ae))
* fix: better selector for the main component and added latest build ([b2fcef1](https://github.com/icebob/vue-form-generator/commit/b2fcef1))
* fix: buttonText instead of caption ([d4b25a9](https://github.com/icebob/vue-form-generator/commit/d4b25a9))
* fix: buttonText instead of caption for unit test file ([f47f704](https://github.com/icebob/vue-form-generator/commit/f47f704))
* fix: Cleavejs better mask definition ([34a6401](https://github.com/icebob/vue-form-generator/commit/34a6401))
* fix: Cleavejs better mask definition ([e338e6d](https://github.com/icebob/vue-form-generator/commit/e338e6d))
* fix: Fixed fragment instances #28 ([0f9863c](https://github.com/icebob/vue-form-generator/commit/0f9863c)), closes [#28](https://github.com/icebob/vue-form-generator/issues/28)
* fix: fragment instance warning ([f9915e6](https://github.com/icebob/vue-form-generator/commit/f9915e6))
* fix: handle disabled and max props of VueMultiSelect better ([e59bcc1](https://github.com/icebob/vue-form-generator/commit/e59bcc1))
* fix: handle disabled and max props of VueMultiSelect better ([9a6fc4b](https://github.com/icebob/vue-form-generator/commit/9a6fc4b))
* fix: handle missing library better ([99b6a4d](https://github.com/icebob/vue-form-generator/commit/99b6a4d))
* fix: handle missing library better ([ec93745](https://github.com/icebob/vue-form-generator/commit/ec93745))
* fix: lint error ([a2665dd](https://github.com/icebob/vue-form-generator/commit/a2665dd))
* fix: lint error and warning ([24c49d9](https://github.com/icebob/vue-form-generator/commit/24c49d9))
* fix: lint error and warning ([54a3502](https://github.com/icebob/vue-form-generator/commit/54a3502))
* fix: package version for `extract-text-webpack-plugin` ([778a9ff](https://github.com/icebob/vue-form-generator/commit/778a9ff))
* fix: remove jQuery from eslint ([74cc91d](https://github.com/icebob/vue-form-generator/commit/74cc91d))
* fix: small bug with quotes ([71ae504](https://github.com/icebob/vue-form-generator/commit/71ae504))
* test: add external libs to karma ([776f6c4](https://github.com/icebob/vue-form-generator/commit/776f6c4))
* test: basic unit testing ([f870dae](https://github.com/icebob/vue-form-generator/commit/f870dae))
* test: fix pikaday expect error ([60a0868](https://github.com/icebob/vue-form-generator/commit/60a0868))
* test: improve karma debug page ([8a094c8](https://github.com/icebob/vue-form-generator/commit/8a094c8))
* test: improve testing of noUiSlider ([59d5036](https://github.com/icebob/vue-form-generator/commit/59d5036))
* test: improve testing of noUiSlider ([42c9ea9](https://github.com/icebob/vue-form-generator/commit/42c9ea9))
* test: improve testing of VueMultiSelect ([09a41f0](https://github.com/icebob/vue-form-generator/commit/09a41f0))
* test: improve unit testing of vueMultiSelect ([1b24293](https://github.com/icebob/vue-form-generator/commit/1b24293))
* test: improve unit testing of vueMultiSelect ([1c09c30](https://github.com/icebob/vue-form-generator/commit/1c09c30))
* test: progress on noUiSlider ([dea27a2](https://github.com/icebob/vue-form-generator/commit/dea27a2))
* test: progress on noUiSlider ([2e7380f](https://github.com/icebob/vue-form-generator/commit/2e7380f))
* test: querySelector instead of querySelectorAll ([00bfbda](https://github.com/icebob/vue-form-generator/commit/00bfbda))
* test: querySelector instead of querySelectorAll ([136b112](https://github.com/icebob/vue-form-generator/commit/136b112))
* test: unit test for field slider ([bb9410d](https://github.com/icebob/vue-form-generator/commit/bb9410d))
* test: unit test for fieldCleave ([012ee91](https://github.com/icebob/vue-form-generator/commit/012ee91))
* test: unit test for fieldGoogleAddress ([63d47aa](https://github.com/icebob/vue-form-generator/commit/63d47aa))
* test: unit test for fieldSpectrum ([0b65bdb](https://github.com/icebob/vue-form-generator/commit/0b65bdb))
* style: add box-sizing ([841f20d](https://github.com/icebob/vue-form-generator/commit/841f20d))
* style: image remove button change to inline img ([92cea99](https://github.com/icebob/vue-form-generator/commit/92cea99))
* dev: add a basic color field for testing ([49e8d43](https://github.com/icebob/vue-form-generator/commit/49e8d43))
* dev: add another port to karma watch, so that it raise no warning when both commands (test and ci) r ([04a71a0](https://github.com/icebob/vue-form-generator/commit/04a71a0))
* dev: noUiSlider with scale ([e1b4126](https://github.com/icebob/vue-form-generator/commit/e1b4126))
* dev: noUiSlider with scale ([dfef1f1](https://github.com/icebob/vue-form-generator/commit/dfef1f1))
* :arrow_up: Fixed #37 ([f4f1f18](https://github.com/icebob/vue-form-generator/commit/f4f1f18)), closes [#37](https://github.com/icebob/vue-form-generator/issues/37)
* :bug: fix: eslint warning ([65b4d59](https://github.com/icebob/vue-form-generator/commit/65b4d59))
* :bug: fix: remove jQuery code ([d0a32cd](https://github.com/icebob/vue-form-generator/commit/d0a32cd))
* :bug: test: Fix noUiSlider test #46 ([7bfffb1](https://github.com/icebob/vue-form-generator/commit/7bfffb1)), closes [#46](https://github.com/icebob/vue-form-generator/issues/46)
* :new: new: add fieldGoogleAddress #33 ([91f9317](https://github.com/icebob/vue-form-generator/commit/91f9317))
* :new: new: new field type: Cleave. Reorganization of dev index file. ([c6e3f5e](https://github.com/icebob/vue-form-generator/commit/c6e3f5e))
* :new: new: new field type: noUiSlider ([9abf3e2](https://github.com/icebob/vue-form-generator/commit/9abf3e2))
* :new: new: new field type: Pikaday. ([b0e3e96](https://github.com/icebob/vue-form-generator/commit/b0e3e96))
* :new: new: new field type: Vue Multiselect ([cef52cb](https://github.com/icebob/vue-form-generator/commit/cef52cb))
* :package: build ([3ab09df](https://github.com/icebob/vue-form-generator/commit/3ab09df))
* :package: build ([def5d7d](https://github.com/icebob/vue-form-generator/commit/def5d7d))
* :package: build ([d7c225a](https://github.com/icebob/vue-form-generator/commit/d7c225a))
* :package: build ([1228b64](https://github.com/icebob/vue-form-generator/commit/1228b64))
* :package: build ([fe76993](https://github.com/icebob/vue-form-generator/commit/fe76993))
* :package: Build ([81073bc](https://github.com/icebob/vue-form-generator/commit/81073bc))
* :package: Build v0.4.0 ([320bacf](https://github.com/icebob/vue-form-generator/commit/320bacf))
* :pencil: docs: fix typo ([ae02461](https://github.com/icebob/vue-form-generator/commit/ae02461))
* :pencil: docs: update readme ([236e9d0](https://github.com/icebob/vue-form-generator/commit/236e9d0))
* :pencil: update README ([09f1acf](https://github.com/icebob/vue-form-generator/commit/09f1acf))
* :pencil2: docs: update readme ([06f55ac](https://github.com/icebob/vue-form-generator/commit/06f55ac))
* :pencil2: docs: update readme ([6c84c69](https://github.com/icebob/vue-form-generator/commit/6c84c69))
* :star: webpack: add stats plugin to webpack ([031f9b0](https://github.com/icebob/vue-form-generator/commit/031f9b0))
* :up: dep: update dependencies ([4ab7a8e](https://github.com/icebob/vue-form-generator/commit/4ab7a8e))
* :up: fix lint errors ([f84be2b](https://github.com/icebob/vue-form-generator/commit/f84be2b))
* :up: improve new fields ([d8e5a8e](https://github.com/icebob/vue-form-generator/commit/d8e5a8e))
* :white_check_mark: fix selectex unit test ([d908f39](https://github.com/icebob/vue-form-generator/commit/d908f39))
* :white_check_mark: test: add fieldCleave & fieldPikaday tests ([22d98b4](https://github.com/icebob/vue-form-generator/commit/22d98b4))
* :white_check_mark: test: add fieldMasked unit test ([19f5d98](https://github.com/icebob/vue-form-generator/commit/19f5d98))
* :white_check_mark: test: fix fieldDateTime test ([14c0602](https://github.com/icebob/vue-form-generator/commit/14c0602))
* :white_check_mark: test: improve multiselect test ([9a26911](https://github.com/icebob/vue-form-generator/commit/9a26911))
* [package] update package.json ([c5b6f33](https://github.com/icebob/vue-form-generator/commit/c5b6f33))
* Add all remainning props and some events (`onNewTag` & `onSearch`) from multiselect and update dev s ([dba3ed7](https://github.com/icebob/vue-form-generator/commit/dba3ed7))
* add every component to the body ([8e528b4](https://github.com/icebob/vue-form-generator/commit/8e528b4))
* add extracted css to package.json ([31a578d](https://github.com/icebob/vue-form-generator/commit/31a578d))
* add fieldSubmit.vue ([9a149d3](https://github.com/icebob/vue-form-generator/commit/9a149d3))
* added most options from vue-multiselect ([9df5b5e](https://github.com/icebob/vue-form-generator/commit/9df5b5e))
* change to fix versions ([8c45e38](https://github.com/icebob/vue-form-generator/commit/8c45e38))
* create test for fieldSubmit ([7b575c3](https://github.com/icebob/vue-form-generator/commit/7b575c3))
* downgrade mocha ([f808219](https://github.com/icebob/vue-form-generator/commit/f808219))
* fix pikaday unit test ([23f5a90](https://github.com/icebob/vue-form-generator/commit/23f5a90))
* improve code quality ([cd7029f](https://github.com/icebob/vue-form-generator/commit/cd7029f))
* improve code quality ([2d2a819](https://github.com/icebob/vue-form-generator/commit/2d2a819))
* Remove dependency from vue-multiselect. Make it optional and check if loaded. Add it to dev files. ([7e3472d](https://github.com/icebob/vue-form-generator/commit/7e3472d))
* remove minimized version. #41 ([1867165](https://github.com/icebob/vue-form-generator/commit/1867165))
* remove node v0.12 because eslint doesn't support it ([314c412](https://github.com/icebob/vue-form-generator/commit/314c412))
* remove submit field from dev sample ([66d201d](https://github.com/icebob/vue-form-generator/commit/66d201d))
* Small changes to `fieldSwitch` to allow easier customization of the width of the switch. ([5a4769e](https://github.com/icebob/vue-form-generator/commit/5a4769e))
* update dependencies ([72d862b](https://github.com/icebob/vue-form-generator/commit/72d862b))
* Update README.md ([f4e7a5b](https://github.com/icebob/vue-form-generator/commit/f4e7a5b))
* Update README.md ([2eae985](https://github.com/icebob/vue-form-generator/commit/2eae985))
* example: change font settings ([6061d4e](https://github.com/icebob/vue-form-generator/commit/6061d4e))
* improve: simple example is more simple ([da5d8cc](https://github.com/icebob/vue-form-generator/commit/da5d8cc))
* styles: add bootstrap styles to .form-control and buttons ([3e7dfc9](https://github.com/icebob/vue-form-generator/commit/3e7dfc9))
* styles: default input width 100%, fieldColor is changed to fix width ([9fc302d](https://github.com/icebob/vue-form-generator/commit/9fc302d))
* styles: fix .wrapper styles ([49d122e](https://github.com/icebob/vue-form-generator/commit/49d122e))
* styles: fix checkbox style ([8e5bb9d](https://github.com/icebob/vue-form-generator/commit/8e5bb9d))
* styles: fix fieldLabel style selector ([b910b3d](https://github.com/icebob/vue-form-generator/commit/b910b3d))
* styles: fix half-width style in dev app ([977d12d](https://github.com/icebob/vue-form-generator/commit/977d12d))
* styles: fix styles of field ([03fd9d2](https://github.com/icebob/vue-form-generator/commit/03fd9d2))
* styles: remove shadow from fieldSwitch ([e0ea478](https://github.com/icebob/vue-form-generator/commit/e0ea478))
* styles: some minor changed ([8204f59](https://github.com/icebob/vue-form-generator/commit/8204f59))
* enhancement: add global class `.vue-form-generator`. Rewriting of most selector for a more encapsula ([e864d10](https://github.com/icebob/vue-form-generator/commit/e864d10))
* enhancement: extract styles to a `vue-form-generator.css` file. ([21c8876](https://github.com/icebob/vue-form-generator/commit/21c8876))
* enhenhancement: remove scoped styles ([1c46aef](https://github.com/icebob/vue-form-generator/commit/1c46aef))
* enhenhancement: remove scoped styles ([4a4641c](https://github.com/icebob/vue-form-generator/commit/4a4641c))



<a name="0.3.0"></a>
# 0.3.0 (2016-07-07)

* :arrow_up: bump version ([249376f](https://github.com/icebob/vue-form-generator/commit/249376f))
* :new: implement #14 ([c6d0a76](https://github.com/icebob/vue-form-generator/commit/c6d0a76))
* :package: build ([9e91fcb](https://github.com/icebob/vue-form-generator/commit/9e91fcb))
* :package: build: v0.3.0 ([8780d3b](https://github.com/icebob/vue-form-generator/commit/8780d3b))
* :pencil: docs: update changelog ([3f3aa31](https://github.com/icebob/vue-form-generator/commit/3f3aa31))
* add maxlength property to fieldText ([3fede6d](https://github.com/icebob/vue-form-generator/commit/3fede6d))
* cover validators.required method ([df2516c](https://github.com/icebob/vue-form-generator/commit/df2516c))
* Move validator error messages to resources #15 ([302ba3f](https://github.com/icebob/vue-form-generator/commit/302ba3f))
* remove joi dependency ([31c24f1](https://github.com/icebob/vue-form-generator/commit/31c24f1))
* improve:  minor change dev code ([84b0a2c](https://github.com/icebob/vue-form-generator/commit/84b0a2c))



<a name="0.2.0"></a>
# 0.2.0 (2016-06-16)

* docs: fix typo in readme ([5530c99](https://github.com/icebob/vue-form-generator/commit/5530c99))
* docs: update changelog ([52fc88c](https://github.com/icebob/vue-form-generator/commit/52fc88c))
* docs: Update changelog ([77b92b6](https://github.com/icebob/vue-form-generator/commit/77b92b6))
* docs: update readme ([b66f9a9](https://github.com/icebob/vue-form-generator/commit/b66f9a9))
* :bug fix: validation bugs ([a403971](https://github.com/icebob/vue-form-generator/commit/a403971))
* :bug: fix: checkbox readonly ([a3d330e](https://github.com/icebob/vue-form-generator/commit/a3d330e))
* :bug: fix: Handle non selected lists ([1714776](https://github.com/icebob/vue-form-generator/commit/1714776))
* :bug: test: fix datetime bugs ([3c132e3](https://github.com/icebob/vue-form-generator/commit/3c132e3))
* :new: new: multiple fields in a row ([da4f766](https://github.com/icebob/vue-form-generator/commit/da4f766))
* :new: new: new field type: Switch ([534c384](https://github.com/icebob/vue-form-generator/commit/534c384))
* :package: bump version to v0.2.0 ([e7b5130](https://github.com/icebob/vue-form-generator/commit/e7b5130))
* :pencil: Update readme example ([0b1c36f](https://github.com/icebob/vue-form-generator/commit/0b1c36f))
* :pencil2: docs ([4940592](https://github.com/icebob/vue-form-generator/commit/4940592))
* :pencil2: docs ([30ff08d](https://github.com/icebob/vue-form-generator/commit/30ff08d))
* :pencil2: docs ([3bb625f](https://github.com/icebob/vue-form-generator/commit/3bb625f))
* :pencil2: docs: Add docs link to readme ([ca1b180](https://github.com/icebob/vue-form-generator/commit/ca1b180))
* :pencil2: docs: Remove from project ([5f70de9](https://github.com/icebob/vue-form-generator/commit/5f70de9))
* :rocket: breaking: change form layout ([57f690b](https://github.com/icebob/vue-form-generator/commit/57f690b))
* :star: new: change slider to ion.rangeSlider ([059cde5](https://github.com/icebob/vue-form-generator/commit/059cde5))
* :start: new: add validator for array ([f0d4c4e](https://github.com/icebob/vue-form-generator/commit/f0d4c4e))
* :white_check_mark: test: abstractField.vue covered 100% ([d0be50b](https://github.com/icebob/vue-form-generator/commit/d0be50b))
* :white_check_mark: test: Add field test cases ([adb4f88](https://github.com/icebob/vue-form-generator/commit/adb4f88))
* :white_check_mark: test: add tests to dateTime field ([4cd7bc6](https://github.com/icebob/vue-form-generator/commit/4cd7bc6))
* :white_check_mark: test: Cover 100% the VueFormGenerator.vue ([6a6299e](https://github.com/icebob/vue-form-generator/commit/6a6299e))
* :white_check_mark: test: cover 94% ([8bede7f](https://github.com/icebob/vue-form-generator/commit/8bede7f))
* :white_check_mark: test: cover all source files ([1d4d898](https://github.com/icebob/vue-form-generator/commit/1d4d898))
* :white_check_mark: test: improve fieldImage tests ([a5d714d](https://github.com/icebob/vue-form-generator/commit/a5d714d))
* :white_check_mark: test: Make abstractField test cases ([564963f](https://github.com/icebob/vue-form-generator/commit/564963f))
* :white_check_mark: test: More fields test cases ([4496149](https://github.com/icebob/vue-form-generator/commit/4496149))
* :white_check_mark: test: More fields test cases ([c1c57be](https://github.com/icebob/vue-form-generator/commit/c1c57be))
* :white_check_mark: test: remove dep. warning ([f04f59d](https://github.com/icebob/vue-form-generator/commit/f04f59d))
* :white_check_mark: test: schema test cases ([540eb63](https://github.com/icebob/vue-form-generator/commit/540eb63))
* :white_check_mark: test: validator tests ([8847b26](https://github.com/icebob/vue-form-generator/commit/8847b26))
* :zap: Impove example ([1193b8f](https://github.com/icebob/vue-form-generator/commit/1193b8f))
* add TODO ([5674df0](https://github.com/icebob/vue-form-generator/commit/5674df0))
* Build v0.2.0 ([023b342](https://github.com/icebob/vue-form-generator/commit/023b342))
* improve styles for multiple fields in a row ([d57f829](https://github.com/icebob/vue-form-generator/commit/d57f829))
* Minor changes ([28ee7a8](https://github.com/icebob/vue-form-generator/commit/28ee7a8))
* Modify examples ([ad2c359](https://github.com/icebob/vue-form-generator/commit/ad2c359))
* Update babel dependencies ([87738f5](https://github.com/icebob/vue-form-generator/commit/87738f5))
* Update README.md ([03d9d1b](https://github.com/icebob/vue-form-generator/commit/03d9d1b))
* Update README.md ([ba41387](https://github.com/icebob/vue-form-generator/commit/ba41387))
* test: cover fieldSwitch ([e31c4ba](https://github.com/icebob/vue-form-generator/commit/e31c4ba))
* test: Fix sinon imports ([81531fe](https://github.com/icebob/vue-form-generator/commit/81531fe))
* fix: Fix schema in dev example ([b6f9f57](https://github.com/icebob/vue-form-generator/commit/b6f9f57))
* fix: lint warnings ([564c0e5](https://github.com/icebob/vue-form-generator/commit/564c0e5))
* fix: remove describe.only ([9bd87a9](https://github.com/icebob/vue-form-generator/commit/9bd87a9))
* improve: sass variable for width in switch field ([e01b816](https://github.com/icebob/vue-form-generator/commit/e01b816))
* chore(package): update conventional-github-releaser to version 1.1.3 ([25477c9](https://github.com/icebob/vue-form-generator/commit/25477c9))
* chore(package): update eslint to version 2.12.0 ([11d00cc](https://github.com/icebob/vue-form-generator/commit/11d00cc))
* chore(package): update gitbook-cli to version 2.3.0 ([83238cc](https://github.com/icebob/vue-form-generator/commit/83238cc))
* chore(package): update joi to version 8.4.2 ([2bc58c5](https://github.com/icebob/vue-form-generator/commit/2bc58c5))
* chore(package): update vue to version 1.0.24 ([adc2a15](https://github.com/icebob/vue-form-generator/commit/adc2a15))
* new: change faker.js to fakerator ([3184fa4](https://github.com/icebob/vue-form-generator/commit/3184fa4))
* build: new dist files ([932a20d](https://github.com/icebob/vue-form-generator/commit/932a20d))
* config: add coverall script to npm ([bee378f](https://github.com/icebob/vue-form-generator/commit/bee378f))
* config: modify coverage scripts ([ec86030](https://github.com/icebob/vue-form-generator/commit/ec86030))



<a name="0.1.1"></a>
## 0.1.1 (2016-05-07)

* :package: Build ([28183bf](https://github.com/icebob/vue-form-generator/commit/28183bf))
* :package: Build ([6ce60d6](https://github.com/icebob/vue-form-generator/commit/6ce60d6))
* :package: Build ([eb4b1f9](https://github.com/icebob/vue-form-generator/commit/eb4b1f9))
* 0.1.1 ([d52c53f](https://github.com/icebob/vue-form-generator/commit/d52c53f))
* Add badges ([b58ec65](https://github.com/icebob/vue-form-generator/commit/b58ec65))
* Add changelog ([5ae0832](https://github.com/icebob/vue-form-generator/commit/5ae0832))
* Add coveralls ([c425ef7](https://github.com/icebob/vue-form-generator/commit/c425ef7))
* Add eslint ([816fc34](https://github.com/icebob/vue-form-generator/commit/816fc34))
* add TODO ([00c9554](https://github.com/icebob/vue-form-generator/commit/00c9554))
* Add travis ci ([182f42e](https://github.com/icebob/vue-form-generator/commit/182f42e))
* change dependencies ([6ba97df](https://github.com/icebob/vue-form-generator/commit/6ba97df))
* Create first test cases ([2246059](https://github.com/icebob/vue-form-generator/commit/2246059))
* Create test environment ([a874195](https://github.com/icebob/vue-form-generator/commit/a874195))
* Create test environment ([8cfde38](https://github.com/icebob/vue-form-generator/commit/8cfde38))
* Fix CI errors. ([0d62830](https://github.com/icebob/vue-form-generator/commit/0d62830))
* Fixed lint errors and warnings ([b88dc5c](https://github.com/icebob/vue-form-generator/commit/b88dc5c))
* Improve webpack config ([f369c90](https://github.com/icebob/vue-form-generator/commit/f369c90))
* More tests ([9cf627c](https://github.com/icebob/vue-form-generator/commit/9cf627c))
* Test cases ([8d2c1dd](https://github.com/icebob/vue-form-generator/commit/8d2c1dd))
* Test cases ([facc6b2](https://github.com/icebob/vue-form-generator/commit/facc6b2))
* Update README.md ([3d7c3a4](https://github.com/icebob/vue-form-generator/commit/3d7c3a4))
* Update README.md ([00999d2](https://github.com/icebob/vue-form-generator/commit/00999d2))
* Update README.md ([10f7bc8](https://github.com/icebob/vue-form-generator/commit/10f7bc8))
* Update README.md ([90403bb](https://github.com/icebob/vue-form-generator/commit/90403bb))
* docs: Add gitbook files ([cb7309e](https://github.com/icebob/vue-form-generator/commit/cb7309e))
* docs: update readme badgets ([43d321c](https://github.com/icebob/vue-form-generator/commit/43d321c))
* docs: update readme badgets ([38b14c9](https://github.com/icebob/vue-form-generator/commit/38b14c9))
* config: add coveralls ([60a3ef1](https://github.com/icebob/vue-form-generator/commit/60a3ef1))



<a name="0.1.0"></a>
# 0.1.0 (2016-05-03)

* Add example ([a81bf42](https://github.com/icebob/vue-form-generator/commit/a81bf42))
* Add files & first build ([6e773d0](https://github.com/icebob/vue-form-generator/commit/6e773d0))
* Add icon to buttons ([b93df72](https://github.com/icebob/vue-form-generator/commit/b93df72))
* Add input mask field ([4e7d5ba](https://github.com/icebob/vue-form-generator/commit/4e7d5ba))
* Added datetime picker field ([5cbaadb](https://github.com/icebob/vue-form-generator/commit/5cbaadb))
* Build ([07bcdae](https://github.com/icebob/vue-form-generator/commit/07bcdae))
* Build ([d856740](https://github.com/icebob/vue-form-generator/commit/d856740))
* Color pickers added. ([16581fb](https://github.com/icebob/vue-form-generator/commit/16581fb))
* Create LICENSE ([74d96f8](https://github.com/icebob/vue-form-generator/commit/74d96f8))
* Create README.md ([31320f2](https://github.com/icebob/vue-form-generator/commit/31320f2))
* Dev environment ([80e0f86](https://github.com/icebob/vue-form-generator/commit/80e0f86))
* Dev environment ([e1f6125](https://github.com/icebob/vue-form-generator/commit/e1f6125))
* Extend dev env ([e7b4ba1](https://github.com/icebob/vue-form-generator/commit/e7b4ba1))
* Handling bootstrap-select ([da8d621](https://github.com/icebob/vue-form-generator/commit/da8d621))
* Image field added. ([053f445](https://github.com/icebob/vue-form-generator/commit/053f445))
* Impove code. Add built-in validators ([8a721d4](https://github.com/icebob/vue-form-generator/commit/8a721d4))
* Initial commit ([15f3df5](https://github.com/icebob/vue-form-generator/commit/15f3df5))
* Modify validation error handling, handle if schema is null ([b849cc0](https://github.com/icebob/vue-form-generator/commit/b849cc0))
* Move build config to root ([52b0775](https://github.com/icebob/vue-form-generator/commit/52b0775))
* Update readme ([a4797c0](https://github.com/icebob/vue-form-generator/commit/a4797c0))
* Update README.md ([032e420](https://github.com/icebob/vue-form-generator/commit/032e420))
* Update README.md ([3c24161](https://github.com/icebob/vue-form-generator/commit/3c24161))
* Update README.md ([3fb6261](https://github.com/icebob/vue-form-generator/commit/3fb6261))



