<div class="form-checkout" id="form-checkout">
    <input type="hidden" name="code" id="booking_code" value="<?php echo e($booking->code); ?>">
    <input type="hidden" name="total" id="booking_total" value="<?php echo e($booking->total); ?>">
    <div class="mb-5 shadow-soft bg-white rounded-sm">
        <div class="pt-4 pb-5 px-5">
            <h5 id="scroll-description" class="font-size-21 font-weight-bold text-dark mb-4">
                <?php echo e(__("Let us know who you are")); ?>

            </h5>
            <div class="row">
                <div class="col-sm-6 mb-4">
                    <label class="form-label">
                        <?php echo e(__("First Name")); ?>

                    </label>
                    <input type="text" placeholder="<?php echo e(__('First Name')); ?>" class="form-control" value="<?php echo e($user->first_name ?? ''); ?>" id="first_name" name="first_name">
                </div>
                <div class="col-sm-6 mb-4">
                    <label class="form-label">
                        <?php echo e(__("Last name")); ?>

                    </label>
                    <input type="text" placeholder="<?php echo e(__('Last Name')); ?>" class="form-control" value="<?php echo e($user->last_name ?? ''); ?>" id="last_name" name="last_name">
                </div>
                <div class="col-sm-6 mb-4">
                    <label class="form-label">
                        <?php echo e(__("Email")); ?>

                    </label>
                    <input type="email" placeholder="<?php echo e(__('email@domain.com')); ?>" class="form-control" value="<?php echo e($user->email ?? ''); ?>" id="email" name="email">
                </div>
                <div class="col-sm-6 mb-4">
                    <label class="form-label">
                        <?php echo e(__("Phone")); ?>

                    </label>
                    <input type="text" placeholder="<?php echo e(__('Your Phone')); ?>" class="form-control" value="<?php echo e($user->phone ?? ''); ?>" id="phone" name="phone">
                </div>
                <div class="w-100"></div>
                <div class="col-sm-6 mb-4">
                    <label class="form-label">
                        <?php echo e(__("Address line 1")); ?>

                    </label>
                    <input type="text" placeholder="<?php echo e(__('Address line 1')); ?>" class="form-control" value="<?php echo e($user->address ?? ''); ?>" id="address_line_1" name="address_line_1">
                </div>
                <div class="col-sm-6 mb-4">
                    <label class="form-label">
                        <?php echo e(__("Address line 2")); ?>

                    </label>
                    <input type="text" placeholder="<?php echo e(__('Address line 2')); ?>" class="form-control" value="<?php echo e($user->address2 ?? ''); ?>" id="address_line_2" name="address_line_2">
                </div>
                <div class="col-sm-6 mb-4">
                    <label class="form-label">
                        <?php echo e(__("State/Province/Region")); ?>

                    </label>
                    <input type="text" class="form-control" value="<?php echo e($user->state ?? ''); ?>" id="state" name="state" placeholder="<?php echo e(__('State/Province/Region')); ?>">
                </div>
                <div class="col-sm-6 mb-4">
                    <label class="form-label">
                        <?php echo e(__("ZIP code/Postal code")); ?>

                    </label>
                    <input type="text" class="form-control" value="<?php echo e($user->zip_code ?? ''); ?>" id="zip_code" name="zip_code" placeholder="<?php echo e(__('ZIP code/Postal code')); ?>">
                </div>
                <div class="col-sm-6 mb-4">

                    <label class="form-label">
                        <?php echo e(__("Country")); ?>

                    </label>
                    <select name="country" id="country" class="form-control">
                        <option value=""><?php echo e(__('-- Select --')); ?></option>
                        <?php $__currentLoopData = get_country_lists(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if(($user->country ?? '') == $id): ?> selected <?php endif; ?> value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-sm-6 mb-4">
                    <label class="form-label">
                        <?php echo e(__("City")); ?>

                    </label>
                    <input type="text" class="form-control" value="<?php echo e($user->city ?? ''); ?>" id="city" name="city" placeholder="<?php echo e(__('Your City')); ?>">
                </div>
                <div class="w-100"></div>
                <div class="col">
                    <div class="mb-6">
                        <label class="form-label">
                            <?php echo e(__("Special Requirements")); ?>

                        </label>
                        <div class="input-group">
                            <textarea name="customer_notes" id="customer_notes" cols="30" rows="6" class="form-control" placeholder="<?php echo e(__('Special Requirements')); ?>"></textarea>
                        </div>
                    </div>
                </div>
                <div class="w-100"></div>
                <div class="col-sm-12 mb-4">
                    <?php echo $__env->make('Booking::frontend/booking/checkout-passengers', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('Booking::frontend/booking/checkout-deposit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make($service->checkout_form_payment_file ?? 'Booking::frontend/booking/checkout-payment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-sm-12 mb-4">
                    <?php
                        $term_conditions = setting_item('booking_term_conditions');
                    ?>
                    <div class="mb-3">
                        <div class="custom-control custom-checkbox d-flex align-items-center text-muted">
                            <input type="checkbox" class="custom-control-input" id="termsCheckbox" name="term_conditions">
                            <label class="custom-control-label" for="termsCheckbox">
                                <small>
                                    <?php echo e(__('By continuing, you agree to the')); ?>

                                    <a target="_blank" class="link-muted" href="<?php echo e(get_page_url($term_conditions)); ?>"><?php echo e(__('Terms and Conditions')); ?></a>
                                </small>
                            </label>
                        </div>
                        <?php if(setting_item("booking_enable_recaptcha")): ?>
                            <div class="form-group">
                                <?php echo e(recaptcha_field('booking')); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="html_before_actions"></div>
                    <p class="alert-text mt10" v-show=" message.content" v-html="message.content" :class="{'danger':!message.type,'success':message.type}"></p>
                    <button v-show="sslEnable" id="sslczPayBtn"
                        token="if you have any token validation"
                        postdata=""
                        order="If you already have the transaction generated for current order"
                        endpoint="<?php echo e(url('/pay-via-ajax')); ?>"> 
                        Pay Now
                    </button>
                    <button v-show="!sslEnable" id="confirm_booking" class="btn btn-primary w-100 rounded-sm transition-3d-hover font-size-16 font-weight-bold py-3" @click="doCheckout"><?php echo e(__('CONFIRM BOOKING')); ?>

                        <i class="fa fa-spin fa-spinner" v-show="onSubmit"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('js'); ?>
<script>
    $(document).ready(function(){
        var obj = {};
        obj.cus_first_name = $('#first_name').val();
        obj.cus_last_name = $('#last_name').val();
        obj.cus_email = $('#email').val();
        obj.cus_phone = $('#phone').val();
        obj.cus_address_line_1 = $('#address_line_1').val();
        obj.cus_address_line_2 = $('#address_line_2').val();
        obj.cus_state = $('#state').val();
        obj.cus_zip_code = $('#zip_code').val();
        obj.cus_country = $('#country').val();
        obj.cus_city = $('#city').val();
        obj.cus_notes = $('#customer_notes').val();
        obj.cus_booking_code = $('#booking_code').val();
        obj.cus_booking_total = $('#booking_total').val();
        obj.cus_payment_gateway = $('#ssl_eccommerce_gateway').val();
        $('#sslczPayBtn').prop('postdata', obj);
        
        // $("#payment_gateway_handel").click(function(){
        //     console.log("handel button");
        //     // $("#confirm_booking").css("display", "none");
        //     // $("#sslczPayBtn").css("display", "block");
        // });
    });
    
</script>
<script>
    (function (window, document) {
        var loader = function () {
            var script = document.createElement("script"), tag = document.getElementsByTagName("script")[0];
            script.src = "https://sandbox.sslcommerz.com/embed.min.js?" + Math.random().toString(36).substring(7);
            tag.parentNode.insertBefore(script, tag);
        };

        window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload", loader);
    })(window, document);

    
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH E:\xampp\htdocs\tripsexpodev\themes/Mytravel/Booking/Views/frontend/booking/checkout-form.blade.php ENDPATH**/ ?>