<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendor_domains', function (Blueprint $table) {
            $table->id();
            $table->string('url',255);
            $table->string('domain_name',255);
            $table->foreignId('vendor_id')->constrained('users');
            $table->string('status')->default('SUBMITTED');
            $table->boolean('id_active')->default(0);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendor_domains');
    }
};