@extends('admin.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between mb20">
        <h1 class="title-bar">{{ __('All Vendor Domain')}}</h1>
    </div>
    @include('admin.message')
    <div class="filter-div d-flex justify-content-between ">
        <div class="col-left">
            @if(!empty($all_vendors))
            <form method="post" action="#" class="filter-form filter-form-left d-flex justify-content-start">
                {{csrf_field()}}
                <select name="action" class="form-control">
                    <option value="">{{__(" Bulk Actions ")}}</option>
                    <option value="delete">{{__(" Delete ")}}</option>
                </select>
                <button data-confirm="{{__("Do you want to delete?")}}"
                    class="btn-info btn btn-icon dungdt-apply-form-btn" type="submit">{{__('Apply')}}</button>
            </form>
            @endif
        </div>
        <div class="col-left">
            <form method="get" class="filter-form filter-form-right d-flex justify-content-end flex-column flex-sm-row"
                role="search">
                <select class="form-control" name="domain-search">
                    <option value="">{{ __('-- Select --')}}</option>
                    <option value="Sub Folder">Sub Folder</option>
                    <option value="Sub Domain">Sub Domain</option>
                    <option value="Domain">Domain</option>

                </select>
                <!-- <input type="text" name="s" value="{{ Request()->s }}" placeholder="{{__('Search by name')}}" class="form-control"> -->
                <button class="btn-info btn btn-icon btn_search" type="submit">{{__('Search User')}}</button>
            </form>
        </div>

    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-body">
                    <form action="" class="bravo-form-item">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th width="60px"><input type="checkbox" class="check-all"></th>
                                        <th>{{__('Vendor Name')}}</th>
                                        <th>{{__('Url Type')}}</th>
                                        <th>{{__('Domain Name')}}</th>
                                        <th>{{__('Created By')}}</th>
                                        <th>{{__('Updated By')}}</th>
                                        <th class="status">{{__('Status')}}</th>
                                        <th class="date">{{ __('Request Date')}}</th>
                                        <th>{{ __('Action')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($all_vendors as $key => $domain)
                                    <tr>
                                        <td><input type="checkbox" name="ids[]" value="{{$domain->id}}"
                                                class="check-item"></td>
                                        <td>{{$domain->vendor->name}}</td>
                                        <td>{{$domain->url}}</td>
                                        <td>{{$domain->domain_name}}</td>
                                        <td>{{$domain->created_by}}</td>
                                        <td>{{$domain->updated_by}}</td>
                                        <td>
                                            @if($domain->id_active == 0)
                                            <span class="domain-pending">{{ __('Pending')}}</span>
                                            @else
                                            <span class="domain-approved">{{ __('Approved')}}</span>
                                            @endif
                                        </td>
                                        <td>{{$domain->created_at}}</td>
                                        <td>
                                            <a href="{{route('vendor.status.update',$domain->id)}}"
                                                class="btn btn-success" title="Approved" id="status_update">
                                                <i class="fa fa-check-circle"></i>
                                            </a>
                                            <button data-fid="{{$domain->id}}" class="btn btn-danger"
                                                id="delete_domain"><i class="fa fa-trash"></i></button>

                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

</div>
@endsection