<?php
namespace Plugins\SslEccomerce\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Library\SslCommerz\SslCommerzNotification;
use Modules\Booking\Events\BookingCreatedEvent;
use Illuminate\Support\Facades\Log;
use Modules\Booking\Models\Booking;

class SslEccomerceCheckoutController extends Controller
{
    public function handleCheckout(Request $request)
    {
        if (!empty($request->input('key')) and !empty($request->input('x_receipt_link_url'))) {
            $twoco_args = http_build_query($request->input(), '', '&');
            return redirect($request->input('x_receipt_link_url') . "&" . $twoco_args);
        }
        return redirect("/");
    }

    public function payViaAjax(Request $request)
    {
        $request_data = (array) json_decode($request->cart_json);
        // dd($request_data);
        # Here you have to receive all the order data to initate the payment.
        # Lets your oder trnsaction informations are saving in a table called "orders"
        # In orders table order uniq identity is "transaction_id","status" field contain status of the transaction, "amount" is the order amount to be paid and "currency" is for storing Site Currency which will be checked with paid currency.

        $post_data = array();
        $post_data['total_amount'] = $request_data['cus_booking_total']; # You cant not pay less than 10
        $post_data['currency'] = "BDT";
        $post_data['tran_id'] = $request_data['cus_booking_code']; // tran_id must be unique

        # CUSTOMER INFORMATION
        $post_data['cus_first_name'] = $request_data['cus_first_name'];
        $post_data['cus_last_name'] = $request_data['cus_last_name'];
        $post_data['cus_email'] =  $request_data['cus_email'];
        $post_data['cus_add1'] = $request_data['cus_address_line_1'];
        $post_data['cus_add2'] = $request_data['cus_address_line_2'];
        $post_data['cus_city'] = $request_data['cus_city'];
        $post_data['cus_state'] = $request_data['cus_state'];
        $post_data['cus_postcode'] = $request_data['cus_zip_code'];
        $post_data['cus_country'] = $request_data['cus_country'];
        $post_data['cus_phone'] = $request_data['cus_phone'];
        $post_data['cus_notes'] = $request_data['cus_notes'];
        $post_data['cus_payment_gateway'] = $request_data['cus_payment_gateway'];
        $post_data['cus_fax'] = "";

        # SHIPMENT INFORMATION
        $post_data['ship_name'] = "Store Test";
        $post_data['ship_add1'] = "Dhaka";
        $post_data['ship_add2'] = "Dhaka";
        $post_data['ship_city'] = "Dhaka";
        $post_data['ship_state'] = "Dhaka";
        $post_data['ship_postcode'] = "1000";
        $post_data['ship_phone'] = "";
        $post_data['ship_country'] = "Bangladesh";

        $post_data['shipping_method'] = "NO";
        $post_data['product_name'] = "Computer";
        $post_data['product_category'] = "Goods";
        $post_data['product_profile'] = "physical-goods";

        # OPTIONAL PARAMETERS
        $post_data['value_a'] = "ref001";
        $post_data['value_b'] = "ref002";
        $post_data['value_c'] = "ref003";
        $post_data['value_d'] = "ref004";


        #Before  going to initiate the payment order status need to update as Pending.
        $update_product = DB::table('bravo_bookings')
            ->where('code', $post_data['tran_id'])
            ->update([
                'first_name' => $post_data['cus_first_name'],
                'last_name' => $post_data['cus_last_name'],
                'email' => $post_data['cus_email'],
                'phone' => $post_data['cus_phone'],
                'total' => $post_data['total_amount'],
                'status' => 'Pending',
                'address' => $post_data['cus_add1'],
                'address2' => $post_data['cus_add2'],
                'city' => $post_data['cus_city'],
                'state' => $post_data['cus_state'],
                'zip_code' => $post_data['cus_postcode'],
                'country' => $post_data['cus_country'],
                'customer_notes' => $post_data['cus_notes'],
                'gateway' => $post_data['cus_payment_gateway'],
                // 'currency' => $post_data['currency']
            ]);

        $sslc = new SslCommerzNotification();
        # initiate(Transaction Data , false: Redirect to SSLCOMMERZ gateway/ true: Show all the Payement gateway here )
        $payment_options = $sslc->makePayment($post_data, 'checkout', 'json');

        if (!is_array($payment_options)) {
            print_r($payment_options);
            $payment_options = array();
        }
    }

    public function success(Request $request)
    {
        // dd($request);
        echo "Transaction is Successful";

        $tran_id = $request->input('tran_id');
        $amount = $request->input('amount');
        // $currency = $request->input('currency');

        $sslc = new SslCommerzNotification();

        #Check order status in order tabel against the transaction id or order id.
        $order_details = DB::table('bravo_bookings')
            ->where('code', $tran_id)
            ->select('code', 'status', 'total')->first();

        if ($order_details->status == 'Pending') {
            $validation = $sslc->orderValidate($request->all(), $tran_id, $amount);

            if ($validation) {
                /*
                That means IPN did not work or IPN URL was not set in your merchant panel. Here you need to update order status
                in order table as Processing or Complete.
                Here you can also sent sms or email for successfull transaction to customer
                */
                $update_product = DB::table('bravo_bookings')
                    ->where('code', $tran_id)
                    ->update(['status' => 'Complete','paid'=>$amount]);

                echo "<br >Transaction is successfully Completed";
            }
        } else if ($order_details->status == 'Processing' || $order_details->status == 'Complete') {
            /*
             That means through IPN Order status already updated. Now you can just show the customer that transaction is completed. No need to udate database.
             */
            echo "Transaction is successfully Completed";
        } else {
            #That means something wrong happened. You can redirect customer to your product page.
            echo "Invalid Transaction";
        }
        
        return redirect()->route('booking.details', ['code' => $tran_id]);
    }

    public function fail(Request $request)
    {
        $tran_id = $request->input('tran_id');

        $order_details = DB::table('bravo_bookings')
            ->where('code', $tran_id)
            ->select('code', 'status','total')->first();

        if ($order_details->status == 'Pending') {
            $update_product = DB::table('bravo_bookings')
                ->where('code', $tran_id)
                ->update(['status' => 'Failed']);
            echo "Transaction is Falied";
        } else if ($order_details->status == 'Processing' || $order_details->status == 'Complete') {
            echo "Transaction is already Successful";
        } else {
            echo "Transaction is Invalid";
        }

        echo  "Transaction is Faild Tripsexpo";

    }

    public function cancel(Request $request)
    {
        $tran_id = $request->input('tran_id');

        $order_details = DB::table('bravo_bookings')
            ->where('code', $tran_id)
            ->select('code', 'status', 'total')->first();

        if ($order_details->status == 'Pending') {
            $update_product = DB::table('bravo_bookings')
                ->where('code', $tran_id)
                ->update(['status' => 'Canceled']);
            echo "Transaction is Cancel";
        } else if ($order_details->status == 'Processing' || $order_details->status == 'Complete') {
            echo "Transaction is already Successful";
        } else {
            echo "Transaction is Invalid";
        }
        echo  "Transaction is Cancel Tripsexpo";


    }

    public function ipn(Request $request)
    {
        #Received all the payement information from the gateway
        if ($request->input('tran_id')) #Check transation id is posted or not.
        {

            $tran_id = $request->input('tran_id');
            $amount = $request->input('amount');

            #Check order status in order tabel against the transaction id or order id.
            $order_details = DB::table('bravo_bookings')
                ->where('code', $tran_id)
                ->select('code', 'status', 'total')->first();

            if ($order_details->status == 'Pending') {
                $sslc = new SslCommerzNotification();
                $validation = $sslc->orderValidate($request->all(), $tran_id, $order_details->amount, $order_details->currency);
                if ($validation == TRUE) {
                    /*
                    That means IPN worked. Here you need to update order status
                    in order table as Processing or Complete.
                    Here you can also sent sms or email for successful transaction to customer
                    */
                    $update_product = DB::table('bravo_bookings')
                    ->where('code', $tran_id)
                    ->update(['status' => 'Complete','paid'=>$amount]);

                    echo "Transaction is successfully Completed";
                }
            } else if ($order_details->status == 'Processing' || $order_details->status == 'Complete') {

                #That means Order status already updated. No need to udate database.

                echo "Transaction is already successfully Completed";
            } else {
                #That means something wrong happened. You can redirect customer to your product page.

                echo "Invalid Transaction";
            }
        } else {
            echo "Invalid Data";
        }
    }
}
