<?php
namespace Plugins\SslEccomerce\Gateway;

use Illuminate\Http\Request;
use Mockery\Exception;
use Modules\Booking\Models\Payment;
use Validator;
use Illuminate\Support\Facades\Log;
use Modules\Booking\Models\Booking;

class SslEccomerceGateway extends \Modules\Booking\Gateways\BaseGateway
{
    protected $id   = 'ssl_eccomerce_gateway';
    public    $name = 'SslEccomerce Checkout';
    protected $gateway;

    public function getOptionsConfigs()
    {
        return [
            [
                'type'  => 'checkbox',
                'id'    => 'enable',
                'label' => __('Enable SslEccomerce?')
            ],
            [
                'type'  => 'input',
                'id'    => 'name',
                'label' => __('Custom Name'),
                'std'   => __("SSLEccomerce"),
                'multi_lang' => "1"
            ],
            [
                'type'  => 'upload',
                'id'    => 'logo_id',
                'label' => __('Custom Logo'),
            ],
            [
                'type'  => 'editor',
                'id'    => 'html',
                'label' => __('Custom HTML Description'),
                'multi_lang' => "1"
            ],
            // [
            //     'type'  => 'input',
            //     'id'    => 'ssl_eccomerce_store_id',
            //     'label' => __('Store ID'),
            // ],
            // [
            //     'type'  => 'input',
            //     'id'    => 'ssl_eccomerce_store_password',
            //     'label' => __('Store Password'),
            // ],
            [
                'type'  => 'checkbox',
                'id'    => 'ssl_eccomerce_sandbox_enable',
                'label' => __('Enable Sandbox Mode'),
            ]
        ];
    }
}
