

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between mb20">
        <h1 class="title-bar"><?php echo e(__('All Vendor Domain')); ?></h1>
    </div>
    <?php echo $__env->make('admin.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="filter-div d-flex justify-content-between ">
        <div class="col-left">
            <?php if(!empty($all_vendors)): ?>
            <form method="post" action="#" class="filter-form filter-form-left d-flex justify-content-start">
                <?php echo e(csrf_field()); ?>

                <select name="action" class="form-control">
                    <option value=""><?php echo e(__(" Bulk Actions ")); ?></option>
                    <option value="delete"><?php echo e(__(" Delete ")); ?></option>
                </select>
                <button data-confirm="<?php echo e(__("Do you want to delete?")); ?>"
                    class="btn-info btn btn-icon dungdt-apply-form-btn" type="submit"><?php echo e(__('Apply')); ?></button>
            </form>
            <?php endif; ?>
        </div>
        <div class="col-left">
            <form method="get" class="filter-form filter-form-right d-flex justify-content-end flex-column flex-sm-row"
                role="search">
                <select class="form-control" name="domain-search">
                    <option value=""><?php echo e(__('-- Select --')); ?></option>
                    <option value="Sub Folder">Sub Folder</option>
                    <option value="Sub Domain">Sub Domain</option>
                    <option value="Domain">Domain</option>

                </select>
                <!-- <input type="text" name="s" value="<?php echo e(Request()->s); ?>" placeholder="<?php echo e(__('Search by name')); ?>" class="form-control"> -->
                <button class="btn-info btn btn-icon btn_search" type="submit"><?php echo e(__('Search User')); ?></button>
            </form>
        </div>

    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-body">
                    <form action="" class="bravo-form-item">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th width="60px"><input type="checkbox" class="check-all"></th>
                                        <th><?php echo e(__('Vendor Name')); ?></th>
                                        <th><?php echo e(__('Url Type')); ?></th>
                                        <th><?php echo e(__('Domain Name')); ?></th>
                                        <th><?php echo e(__('Created By')); ?></th>
                                        <th><?php echo e(__('Updated By')); ?></th>
                                        <th class="status"><?php echo e(__('Status')); ?></th>
                                        <th class="date"><?php echo e(__('Request Date')); ?></th>
                                        <th><?php echo e(__('Action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $all_vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $domain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><input type="checkbox" name="ids[]" value="<?php echo e($domain->id); ?>"
                                                class="check-item"></td>
                                        <td><?php echo e($domain->vendor->name); ?></td>
                                        <td><?php echo e($domain->url); ?></td>
                                        <td><?php echo e($domain->domain_name); ?></td>
                                        <td><?php echo e($domain->created_by); ?></td>
                                        <td><?php echo e($domain->updated_by); ?></td>
                                        <td>
                                            <?php if($domain->id_active == 0): ?>
                                            <span class="domain-pending"><?php echo e(__('Pending')); ?></span>
                                            <?php else: ?>
                                            <span class="domain-approved"><?php echo e(__('Approved')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($domain->created_at); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('vendor.status.update',$domain->id)); ?>"
                                                class="btn btn-success" title="Approved" id="status_update">
                                                <i class="fa fa-check-circle"></i>
                                            </a>
                                            <button data-fid="<?php echo e($domain->id); ?>" class="btn btn-danger"
                                                id="delete_domain"><i class="fa fa-trash"></i></button>

                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\tripsexpodev\modules/User/Views/admin/vendor-domain-list.blade.php ENDPATH**/ ?>