

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex justify-content-between mb20">
            <h1 class="title-bar"><?php echo e(__("Vendor Requests")); ?></h1>
        </div>
        <?php echo $__env->make('admin.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="filter-div d-flex justify-content-between ">
            <div class="col-left">
                <?php if(!empty($rows)): ?>
                    <form method="post" action="<?php echo e(route('user.admin.userUpgradeRequestApproved')); ?>" class="filter-form filter-form-left d-flex justify-content-start">
                        <?php echo e(csrf_field()); ?>

                        <select name="action" class="form-control">
                            <option value=""><?php echo e(__(" Bulk Actions ")); ?></option>
                            <option value="approved"><?php echo e(__(" Approved ")); ?></option>
                            <option value="delete"><?php echo e(__(" Delete ")); ?></option>
                        </select>
                        <button data-confirm="<?php echo e(__("Do you want to delete?")); ?>" class="btn-info btn btn-icon dungdt-apply-form-btn" type="button"><?php echo e(__('Apply')); ?></button>
                    </form>
                <?php endif; ?>
            </div>

        </div>
        <div class="text-right">
            <p><i><?php echo e(__('Found :total items',['total'=>$rows->total()])); ?></i></p>
        </div>
        <div class="panel">
            <div class="panel-body">
                <form action="" class="bravo-form-item">
                    <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                        <tr>
                            <th width="60px"><input type="checkbox" class="check-all"></th>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Email')); ?></th>
                            <th><?php echo e(__('Role request')); ?></th>
                            <th class="date"><?php echo e(__('Date request')); ?></th>
                            <th class="date"><?php echo e(__('Reject / Approved Date')); ?></th>
                            <th><?php echo e(__('Approved / Reject By')); ?></th>
                            <th class="status"><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Actions')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if($rows->total() > 0): ?>
                            <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><input type="checkbox" name="ids[]" value="<?php echo e($row->id); ?>" class="check-item"></td>
                                    <td class="title">
                                        <a href="<?php echo e(route('user.admin.detail',['id'=>@$row->user->id])); ?>"><?php echo e(@$row->user->getDisplayName()); ?></a>
                                    </td>
                                    <td><?php echo e($row->user->email); ?></td>
                                    <td>
                                        <?php $role = $row->role;
                                    if(!empty($role)){
                                        echo e(ucfirst($role->name));
                                    }
                                        ?>
                                    </td>
                                    <td><?php echo e(display_date($row->created_at)); ?></td>
                                    <td><?php echo e($row->approved_time ? display_date($row->approved_time) : ''); ?></td>
                                    <td><?php echo e($row->approvedBy->getDisplayName()); ?></td>
                                    <td class="status"><span class="badge badge-<?php echo e($row->status); ?>"><?php echo e($row->status); ?></span></td>
                                    <td class="action-button">
                                            <a class="btn btn-sm btn-primary" title="Edit" target="_blank" href="<?php echo e(route('user.admin.detail',$row->user_id)); ?>">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                        <?php if($row->status!='approved' && $row->status!='reject'): ?>
                                            <a class="btn btn-sm btn-success approve-user" data-id="<?php echo e($row->id); ?>" title="Approve"  href="<?php echo e(route('user.admin.upgradeId',['id' => $row->id])); ?>">
                                                <i class="fa fa-check"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger reject-user" data-id="<?php echo e($row->id); ?>" title="Reject" data-toggle="modal" data-target="#exampleModalCenter"><i class="fa fa-close"></i></button>
                                        <?php endif; ?>
                                        <?php if($row->status!='approved' && $row->status=='reject'): ?>
                                            <button type="button" class="btn btn-info view-reject-reason" title="View" data-id="<?php echo e($row->id); ?>"><i class="fa fa-eye"></i></button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8"><?php echo e(__("No data")); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                    </div>
                </form>
                <?php echo e($rows->appends(request()->query())->links()); ?>

                <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(__("Cancel Reason")); ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form action="">
                                <div class="form-group">
                                    <input type="hidden" id="reason_id" name="reason_id">
                                    <textarea name="cancel_reason" id="cancel_reason" rows="5" style="width: 100%;"></textarea>
                                    <span id="valid_sms" style="color:red; margin-top:10px;display:none"><?php echo e(__('this field is required')); ?></span>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary" id="submit-reason">Save changes</button>
                        </div>
                        </div>
                    </div>
                </div>
                <div class="modal fade" id="viewRejectReason" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(__("Cancel Reason")); ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">  
                            <p id="showCancelContent"></p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function () {
            // $('.approve-user').click(function (e) {
            //     e.preventDefault();
            //     if(confirm('Are you sure approve?')){
            //         ids = '<input type="hidden" name="ids[]" value="'+$(this).data('id')+'">';
            //         form = $('.dungdt-apply-form-btn').closest('form');
            //         form.append(ids);
            //         form.find('select').val('approved');
            //         form.submit();
            //     }
            // });
            // cancel reason 
            $('.reject-user').click(function(e){
                var id = $(this).data('id');
                $('#reason_id').val(id);

                $("#submit-reason").on("click",function(){
                    var cancelReason = $("#cancel_reason").val();
                    
                    if(cancelReason === ""){
                        console.log("massage null");
                        $("#valid_sms")[0].style.display = "block";
                        $("#cancel_reason")[0].style.borderColor = "red";
                    }else{
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                            }
                        });
                        var url = '<?php echo e(route("vendor.reject", ":id")); ?>';
                            url = url.replace(':id', id );
                        $.ajax({
                            url: url,
                            method: 'post',
                            data: {
                                cancel_reason: $('#cancel_reason').val(),
                            },
                            success: function(result){
                                // console.log(result);
                                $('#exampleModalCenter').modal('hide');
                                location.reload();
                            }
                        });
                        
                    }
                })
            });
            // cancel reason view
            $('.view-reject-reason').on("click",function(){
                var id = $(this).data('id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                    }
                });
                var url = '<?php echo e(route("vendor.reject.view", ":id")); ?>';
                    url = url.replace(':id', id );
                $.ajax({
                    url: url,
                    method: 'get',
                    success: function(result){
                        var cancelReason = result.cancel_reason;
                        $("#showCancelContent").html(cancelReason);
                        $('#viewRejectReason').modal('show');
                        
                    }
                });
            })
            

        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\tripsexpodev\modules/User/Views/admin/upgrade-user.blade.php ENDPATH**/ ?>