@extends('Email::layout')
@section('content')

    <div class="b-container">
        @switch($to)
            @case('admin')
                <div class="b-panel">
                    <h3 class="email-headline"><strong>{{__('Hello Administrator')}}</strong></h3>
                    <p>{{__('New booking has been made')}}</p>
                    @include($service->email_new_booking_file ?? '')
                </div>
                @include('Booking::emails.parts.panel-customer')
                @include('Booking::emails.parts.panel-passengers')
                @break
            @case('vendor')
                <div class="b-panel">
                    <h3 class="email-headline"><strong>{{__('Hello :name',['name'=>$booking->vendor->nameOrEmail ?? ''])}}</strong></h3>
                    <p>{{__('Your service has new booking')}}</p>
                    @include($service->email_new_booking_file ?? '')
                </div>
                @include('Booking::emails.parts.panel-customer')
                @include('Booking::emails.parts.panel-passengers')
                @break
            @case('customer')
                <div class="b-panel">
                    <h3 class="email-headline"><strong>{{__('Hello :name',['name'=>$booking->vendor->nameOrEmail ?? ''])}}</strong></h3>
                    <p>{{__('Your service has new booking')}}</p>
                    @include($service->email_new_booking_file ?? '')
                </div>
                @include('Booking::emails.parts.panel-vendor')
                @include('Booking::emails.parts.panel-passengers')
                @break
        @endswitch
    </div>
@endsection
