@extends('layouts.app')
@push('css')
    <link href="{{ asset('/themes/mytravel/dist/frontend/module/tour/css/tour.css?_ver='.config('app.asset_version')) }}" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="{{ asset('libs/fotorama/fotorama.css') }}"/>
@endpush
@section('content')
    <div class="bravo_detail_tour tour-compare">
       <div class="container">
            <nav class="compare-breadcrumb-wrap" aria-label="breadcrumb">
                <ol class="breadcrumb breadcrumb-no-gutter mb-0 flex-nowrap flex-xl-wrap overflow-auto overflow-xl-visble">
                    <li class="breadcrumb-item flex-shrink-0 flex-xl-shrink-1"><a href="{{url('')}}">{{__('Home')}}</a></li>
                    @foreach($breadcrumbs as $breadcrumb)
                        <li class="breadcrumb-item flex-shrink-0 flex-xl-shrink-1 {{$breadcrumb['class'] ?? ''}}">
                            @if(!empty($breadcrumb['url']))
                                <a href="{{url($breadcrumb['url'])}}">{{$breadcrumb['name']}}</a>
                            @else
                                {{$breadcrumb['name']}}
                            @endif
                        </li>
                    @endforeach
                </ol>
            </nav>
            <div class="row">
                <div class="col-lg-12">
                    <div class="compare-table">
                        <table class="table-bordered">
                            <tbody>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        <td class="remove-button-wrap">
                                            <a href="{{$row->slug}}" target="_blank">{{$row->title}}</a>
                                            <button class="btn btn-sm btn-danger" onclick="CompareTourRemove('{{$row->id}}')"><i class="fa fa-close"></i></button>
                                        </td>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        <td>
                                        @if($row->personGroup->enable_person_types == 1)
                                            @php
                                                $numbers = array_column($row->personGroup->person_types, 'price');
                                                $min = min($numbers);
                                            @endphp 
                                            {{format_money($min)}}
                                        @else
                                            {{format_money($row->price)}}
                                        @endif
                                        </td>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        <td>
                                        @if(setting_item('tour_enable_review'))
                                            <?php
                                            $reviewData = $row->getScoreReview();
                                            $score_total = $reviewData['score_total'];
                                            ?>
                                            <div class="ml-2 service-review review-{{$score_total}}">
                                                <div class="d-inline-flex align-items-center font-size-17 text-lh-1 text-primary">
                                                    <div class="list-star green-lighter mr-2">
                                                        <ul class="booking-item-rating-stars">
                                                            <li><i class="fa fa-star-o"></i></li>
                                                            <li><i class="fa fa-star-o"></i></li>
                                                            <li><i class="fa fa-star-o"></i></li>
                                                            <li><i class="fa fa-star-o"></i></li>
                                                            <li><i class="fa fa-star-o"></i></li>
                                                        </ul>
                                                        <div class="booking-item-rating-stars-active" style="width: {{  $score_total * 2 * 10 ?? 0  }}%">
                                                            <ul class="booking-item-rating-stars">
                                                                <li><i class="fa fa-star"></i></li>
                                                                <li><i class="fa fa-star"></i></li>
                                                                <li><i class="fa fa-star"></i></li>
                                                                <li><i class="fa fa-star"></i></li>
                                                                <li><i class="fa fa-star"></i></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                    <span class="text-secondary font-size-14 mt-1">
                                                        @if($reviewData['total_review'] > 1)
                                                            {{ __(":number Reviews",["number"=>$reviewData['total_review'] ]) }}
                                                        @else
                                                            {{ __(":number Review",["number"=>$reviewData['total_review'] ]) }}
                                                        @endif
                                                    </span>
                                                </div>
                                            </div>
                                        @endif
                                        </td>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        <td>
                                            @if($row->duration)
                                                {{duration_format($row->duration,true)}}
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        <td>
                                            @if($row->duration)
                                                {{ __("Max People") }} : {{ $row->max_people }}
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        <td>
                                        @if($row->wifi_available)
                                            {{ __("Wifi Available") }}
                                        @else
                                            {{ __("Wifi Unavailable") }}
                                        @endif
                                        </td>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        <td>
                                            @if($row->date_form_to)
                                                {{ $row->date_form_to }}
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        <td>
                                            @if($row->min_age)
                                                {{ __('Min Age:') }} {{ $row->min_age }}
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        <td>
                                            @if($row->pickup)
                                                {{ __("Pickup:") }} {{ __("$row->pickup") }}
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        @if($row->include != null)
                                            <td>
                                                @foreach($row->include as $item)
                                                    <div class="mb-3 text-gray-1">
                                                        <i class="flaticon-tick mr-3 font-size-16 text-primary"></i>
                                                        {{$item['title']}}
                                                    </div>
                                                @endforeach
                                            </td>
                                        @endif
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($rows as $key => $row)
                                        <td>
                                            @if($row->exclude != null)
                                                @foreach($row->exclude as $item)
                                                    <div class="mb-3 text-gray-1">
                                                        <i class="flaticon-close mr-3 font-size-16 text-danger"></i>
                                                        {{$item['title']}}
                                                    </div>
                                                @endforeach
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                                <tr class="text-center">
                                    @foreach($rows as $key => $row)
                                        <td>
                                            <a href="{{$row->slug}}" class="btn btn-sm btn-primary" target="_blank">Details</a>
                                        </td>
                                    @endforeach
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
       </div>
    </div>
@endsection


